<?php
namespace App\Controllers;

/**
 * Base API Controller
 */
abstract class ApiController
{
    protected function jsonResponse($data, $statusCode = 200)
    {
        header('Content-Type: application/json; charset=utf-8');
        http_response_code($statusCode);
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        exit;
    }

    protected function successResponse($data = [], $message = '')
    {
        $response = ['status' => 'success'];
        if (!empty($message)) {
            $response['message'] = $message;
        }
        if (!empty($data)) {
            $response = array_merge($response, $data);
        }
        $this->jsonResponse($response);
    }

    protected function errorResponse($message, $statusCode = 400)
    {
        $this->jsonResponse(['status' => 'error', 'message' => $message], $statusCode);
    }
}

