<?php
namespace App\Controllers;

use App\Repositories\AuditLogRepository;
use App\Services\AuthService;
use App\Utils\Sanitizer;

class AuditLogController extends ApiController
{
    private AuditLogRepository $repo;
    private AuthService $authService;

    public function __construct(AuditLogRepository $repo, AuthService $authService)
    {
        $this->repo = $repo;
        $this->authService = $authService;
    }

    public function list()
    {
        if (!$this->authService->isAdmin()) {
            $this->errorResponse('فقط مدیر می‌تواند لاگ‌ها را ببیند');
        }

        $filters = [
            'action' => Sanitizer::sanitize($_POST['action'] ?? ''),
            'entity_type' => Sanitizer::sanitize($_POST['entity_type'] ?? ''),
            'entity_id' => Sanitizer::sanitize($_POST['entity_id'] ?? ''),
            'person_search' => Sanitizer::sanitize($_POST['person_search'] ?? ''),
            'date_from' => Sanitizer::sanitize($_POST['date_from'] ?? ''),
            'date_to' => Sanitizer::sanitize($_POST['date_to'] ?? ''),
            'limit' => (int)($_POST['limit'] ?? 100),
            'offset' => (int)($_POST['offset'] ?? 0),
        ];

        // Normalize empty strings
        foreach (['action','entity_type','entity_id','date_from','date_to','person_search'] as $k) {
            if (isset($filters[$k]) && trim((string)$filters[$k]) === '') {
                $filters[$k] = '';
            }
        }

        $result = $this->repo->list($filters);
        $this->successResponse(['logs' => $result]);
    }
}

