<?php
namespace App\Controllers;

use App\Services\AuthService;
use App\Services\ExportService;
use App\Utils\Sanitizer;

class ExportController extends ApiController
{
    private ExportService $exportService;
    private AuthService $authService;

    public function __construct(ExportService $exportService, AuthService $authService)
    {
        $this->exportService = $exportService;
        $this->authService = $authService;
    }

    public function catalog()
    {
        if (!$this->authService->isAdmin()) {
            $this->errorResponse('فقط مدیر می‌تواند خروجی بگیرد');
        }

        $this->successResponse($this->exportService->getCatalog());
    }

    public function run()
    {
        if (!$this->authService->isAdmin()) {
            $this->errorResponse('فقط مدیر می‌تواند خروجی بگیرد');
        }

        $dataset = Sanitizer::sanitize($_POST['dataset'] ?? '');
        $format = Sanitizer::sanitize($_POST['format'] ?? 'csv');
        $columnsJson = $_POST['columns_json'] ?? '[]';
        $filtersJson = $_POST['filters_json'] ?? '{}';

        $columns = json_decode((string)$columnsJson, true);
        $filters = json_decode((string)$filtersJson, true);
        if (!is_array($columns)) $columns = [];
        if (!is_array($filters)) $filters = [];

        // Convert checkbox to boolean
        if (isset($filters['include_raw_json'])) {
            $filters['include_raw_json'] = $filters['include_raw_json'] === '1' || $filters['include_raw_json'] === 1 || $filters['include_raw_json'] === true;
        }

        // This method streams a file and exits.
        $this->exportService->export($dataset, $columns, $filters, $format);
        exit;
    }
}

