<?php
namespace App\Controllers;

use App\Services\AuthService;

/**
 * Simple migration controller to support the legacy "run_migration" button
 * in the admin users view. In the new MySQL-based architecture, the schema
 * is already correct, so this endpoint mostly reports success and can be
 * extended in the future if needed.
 */
class MigrationController extends ApiController
{
    private $authService;

    public function __construct(AuthService $authService)
    {
        $this->authService = $authService;
    }

    /**
     * Run any pending manual migrations (currently a no-op for MySQL).
     */
    public function run()
    {
        if (!$this->authService->isAdmin()) {
            $this->errorResponse('فقط مدیر می‌تواند migration را اجرا کند');
        }

        // In the refactored MySQL schema, the users.role constraint is already correct.
        // We keep this endpoint so that the "run migration" button continues to work.
        $this->successResponse([], 'Migration در نسخه فعلی سیستم قبلاً اعمال شده است');
    }
}


