<?php
namespace App\Controllers;

use App\Repositories\ProductRepository;
use App\Services\AuthService;
use App\Utils\Sanitizer;

class ProductController extends ApiController
{
    private $productRepo;
    private $authService;

    public function __construct(ProductRepository $productRepo, AuthService $authService)
    {
        $this->productRepo = $productRepo;
        $this->authService = $authService;
    }

    public function getList()
    {
        $products = $this->productRepo->all();
        $this->successResponse(['products' => array_map(fn($p) => $p->toArray(), $products)]);
    }

    public function getUsedInDeals()
    {
        $products = $this->productRepo->allUsedInDeals();
        $this->successResponse(['products' => array_map(fn($p) => $p->toArray(), $products)]);
    }

    public function getKpiList()
    {
        $products = $this->productRepo->allAllowedServices();
        $this->successResponse(['products' => array_map(fn($p) => $p->toArray(), $products)]);
    }

    public function save()
    {
        if (!$this->authService->isAdmin()) {
            $this->errorResponse('فقط ادمین می‌تواند محصول را مدیریت کند');
        }
        $name = Sanitizer::sanitize($_POST['name'] ?? '');
        if (empty($name)) {
            $this->errorResponse('نام محصول الزامی است');
        }
        $this->productRepo->create($name);
        $this->successResponse([], 'محصول با موفقیت اضافه شد');
    }

    public function delete()
    {
        if (!$this->authService->isAdmin()) {
            $this->errorResponse('فقط ادمین می‌تواند محصول را حذف کند');
        }
        $id = (int)($_POST['id'] ?? 0);
        if ($id <= 0) {
            $this->errorResponse('شناسه محصول نامعتبر است');
        }
        $this->productRepo->delete($id);
        $this->successResponse([], 'محصول حذف شد');
    }
}
