<?php
namespace App\Controllers;

use App\Repositories\ConfigRepository;
use App\Services\AuthService;

class SettingsController extends ApiController
{
    private ConfigRepository $configRepo;
    private AuthService $authService;

    public function __construct(ConfigRepository $configRepo, AuthService $authService)
    {
        $this->configRepo = $configRepo;
        $this->authService = $authService;
    }

    public function getDidarWriteSettings(): void
    {
        $this->ensureAdmin();

        $value = $this->configRepo->getValue('didar_write_enabled', '1');
        $enabled = $this->normalizeFlag($value);

        $this->successResponse(['didar_write_enabled' => $enabled ? '1' : '0']);
    }

    public function saveDidarWriteSettings(): void
    {
        $this->ensureAdmin();

        $raw = $_POST['didar_write_enabled'] ?? '1';
        $enabled = $this->normalizeFlag($raw);

        $this->configRepo->setValue('didar_write_enabled', $enabled ? '1' : '0');

        $this->successResponse(['didar_write_enabled' => $enabled ? '1' : '0'], 'تنظیمات با موفقیت ذخیره شد');
    }

    private function ensureAdmin(): void
    {
        if (!$this->authService->isAdmin()) {
            $this->errorResponse('دسترسی محدود به مدیر سیستم');
        }
    }

    private function normalizeFlag($value): bool
    {
        $normalized = is_string($value) ? strtolower(trim($value)) : $value;
        return in_array($normalized, [1, '1', true, 'true', 'on', 'yes'], true);
    }
}
