<?php
namespace App\Controllers;

use App\Services\SyncService;
use App\Services\AuthService;

class SyncController extends ApiController
{
    private $syncService;
    private $authService;

    public function __construct(SyncService $syncService, AuthService $authService)
    {
        $this->syncService = $syncService;
        $this->authService = $authService;
    }

    public function sync()
    {
        if (!$this->authService->isAdmin()) {
            $this->errorResponse('فقط مدیر سیستم می‌تواند همگام‌سازی انجام دهد');
        }
        
        $entityType = $_POST['entity_type'] ?? 'all';
        
        try {
            $results = [];
            
            if ($entityType === 'all' || $entityType === 'users') {
                $results['users'] = $this->syncService->syncUsers();
            }
            
            if ($entityType === 'all' || $entityType === 'persons') {
                $results['persons'] = $this->syncService->syncPersons();
            }
            
            if ($entityType === 'all' || $entityType === 'deals') {
                $results['deals'] = $this->syncService->syncDeals();
            }
            
            if ($entityType === 'all' || $entityType === 'activities') {
                $results['activities'] = $this->syncService->syncActivities();
            }
            
            $this->successResponse(['results' => $results], 'همگام‌سازی با موفقیت انجام شد');
        } catch (Exception $e) {
            $this->errorResponse($e->getMessage());
        }
    }
}

