<?php
namespace App\Middleware;

use App\Services\AuthService;

/**
 * Authentication Middleware
 */
class AuthMiddleware
{
    private $authService;

    public function __construct(AuthService $authService)
    {
        $this->authService = $authService;
    }

    public function handle($callback)
    {
        if (!$this->authService->isAuthenticated()) {
            header('Content-Type: application/json');
            echo json_encode(['status' => 'error', 'message' => 'لطفاً ابتدا وارد شوید']);
            exit;
        }
        
        return $callback();
    }
}

