<?php
namespace App\Middleware;

use App\Services\AuthService;

/**
 * Role-based Access Control Middleware
 */
class RoleMiddleware
{
    private $authService;

    public function __construct(AuthService $authService)
    {
        $this->authService = $authService;
    }

    public function requireAdmin($callback)
    {
        if (!$this->authService->isAdmin()) {
            header('Content-Type: application/json');
            echo json_encode(['status' => 'error', 'message' => 'دسترسی محدود به مدیر سیستم']);
            exit;
        }
        
        return $callback();
    }

    public function requireAdminOrCrm($callback)
    {
        if (!$this->authService->isAdminOrCrmSpecialist()) {
            header('Content-Type: application/json');
            echo json_encode(['status' => 'error', 'message' => 'دسترسی محدود']);
            exit;
        }
        
        return $callback();
    }
}

