<?php
namespace App\Models;

/**
 * Deal Model
 */
class Deal
{
    public $id;
    public $didar_deal_id;
    public $owner_didar_id;
    public $contact_didar_id;
    public $title;
    public $code;
    public $status;
    public $pipeline_stage;
    public $failure_reason_code;
    public $failure_reason_text;
    public $failure_reason_description;
    public $pipeline_stage_id;
    public $pipeline_stage_title;
    public $estimated_price;
    public $final_price;
    public $probability;
    public $is_paid;
    public $payment_short_link;
    public $service_name;
    public $service_cost;
    public $price_list_code;
    public $has_discount;
    public $discount_type;
    public $discount_occasion;
    public $discount_amount;
    public $refund_amount;
    public $refund_description;
    public $payable_amount;
    public $payment_conditions;
    public $payment_amount;
    public $payment_method;
    public $payment_description;
    public $payments;
    public $requested_services;
    public $financial_level;
    public $asset_estimation;
    public $income_estimation;
    public $has_previous_purchase;
    public $city;
    public $job_title;
    public $job_description;
    public $acquaintance_duration;
    public $extra_info;
    public $register_time;
    public $last_update_time;
    public $won_time;
    public $lost_time;
    public $visibility_type;
    public $last_sync;
    public $raw_json;
    public $created_at;

    // Extra fields from joins (not persisted in deals table)
    public $local_person_id;
    public $contact_name;
    public $contact_mobile;
    public $owner_name;

    public function __construct(array $data = [])
    {
        foreach ($data as $key => $value) {
            if (property_exists($this, $key)) {
                $this->$key = $value;
            }
        }
    }

    public function toArray()
    {
        return get_object_vars($this);
    }
}

