<?php
namespace App\Models;

/**
 * Support Model
 * Represents a CRM support log entry
 */
class Support
{
    public $id;
    public $contact_didar_id;
    public $channel;  // call, chat, visit, email
    public $direction;  // incoming, outgoing
    public $result_note;
    public $created_by_didar_id;
    public $created_at;
    public $updated_at;
    
    // Additional fields that may be joined
    public $creator_name;
    public $contact_name;
    public $contact_phone;
    
    public function __construct(array $data = [])
    {
        $this->id = $data['id'] ?? null;
        $this->contact_didar_id = $data['contact_didar_id'] ?? '';
        $this->channel = $data['channel'] ?? 'call';
        $this->direction = $data['direction'] ?? 'incoming';
        $this->result_note = $data['result_note'] ?? '';
        $this->created_by_didar_id = $data['created_by_didar_id'] ?? '';
        $this->created_at = $data['created_at'] ?? null;
        $this->updated_at = $data['updated_at'] ?? null;
        
        // Additional fields
        $this->creator_name = $data['creator_name'] ?? '';
        $this->contact_name = $data['contact_name'] ?? '';
        $this->contact_phone = $data['contact_phone'] ?? '';
    }
    
    public function toArray(): array
    {
        return [
            'id' => $this->id,
            'contact_didar_id' => $this->contact_didar_id,
            'channel' => $this->channel,
            'direction' => $this->direction,
            'result_note' => $this->result_note,
            'created_by_didar_id' => $this->created_by_didar_id,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'creator_name' => $this->creator_name,
            'contact_name' => $this->contact_name,
            'contact_phone' => $this->contact_phone,
        ];
    }
}

