<?php
namespace App\Utils;

// Ensure constants are loaded
if (!defined('LOG_FILE')) {
    require_once __DIR__ . '/../config/constants.php';
}

/**
 * Logger Utility Class
 */
class Logger
{
    /**
     * Write log entry
     */
    public static function writeLog($message, $level = 'INFO', $context = [])
    {
        $timestamp = date('Y-m-d H:i:s');
        $logEntry = sprintf(
            "[%s] [%s] %s %s\n",
            $timestamp,
            $level,
            $message,
            !empty($context) ? json_encode($context, JSON_UNESCAPED_UNICODE) : ''
        );
        
        // Write to general log
        @file_put_contents(LOG_FILE, $logEntry, FILE_APPEND | LOCK_EX);
        
        // Write to error log if error
        if (in_array($level, ['ERROR', 'CRITICAL'])) {
            @file_put_contents(ERROR_LOG_FILE, $logEntry, FILE_APPEND | LOCK_EX);
        }
        
        // Also log to PHP error_log for server logs
        if (in_array($level, ['ERROR', 'CRITICAL', 'WARNING'])) {
            error_log($logEntry);
        }
    }

    public static function logError($message, $exception = null, $context = [])
    {
        $context['exception'] = $exception ? [
            'message' => $exception->getMessage(),
            'file' => $exception->getFile(),
            'line' => $exception->getLine(),
            'trace' => $exception->getTraceAsString()
        ] : null;
        self::writeLog($message, 'ERROR', $context);
    }

    public static function logInfo($message, $context = [])
    {
        self::writeLog($message, 'INFO', $context);
    }

    public static function logWarning($message, $context = [])
    {
        self::writeLog($message, 'WARNING', $context);
    }

    public static function logDebug($message, $context = [])
    {
        self::writeLog($message, 'DEBUG', $context);
    }
}

