<?php
namespace App\Utils;

/**
 * Sanitizer Utility Class
 */
class Sanitizer
{
    /**
     * Sanitize input data
     */
    public static function sanitize($data)
    {
        return htmlspecialchars(strip_tags(trim($data)), ENT_QUOTES, 'UTF-8');
    }

    /**
     * Clean HTML from notes
     */
    public static function cleanNote($html)
    {
        if (empty($html)) return '';
        $text = strip_tags($html);
        $text = html_entity_decode($text, ENT_QUOTES, 'UTF-8');
        return trim($text);
    }
}

