<?php
namespace App\Utils;

/**
 * Validator Utility Class
 */
class Validator
{
    /**
     * Validate Persian text
     */
    public static function validatePersianText($text, $fieldName)
    {
        if (empty(trim($text))) {
            return ['valid' => true]; // Allow empty
        }
        // فقط حروف فارسی، فاصله و اعراب
        if (!preg_match('/^[\x{0600}-\x{06FF}\s\x{200C}\x{200D}]+$/u', trim($text))) {
            return ['valid' => false, 'message' => "$fieldName باید فقط شامل حروف فارسی باشد"];
        }
        return ['valid' => true, 'cleaned' => trim($text)];
    }

    /**
     * Validate National ID
     */
    public static function validateNationalId($nationalId)
    {
        if (empty(trim($nationalId))) {
            return ['valid' => true]; // Allow empty
        }
        $cleaned = preg_replace('/\D/', '', trim($nationalId));
        if (strlen($cleaned) !== 10) {
            return ['valid' => false, 'message' => 'کد ملی باید دقیقاً 10 رقم باشد'];
        }
        return ['valid' => true, 'cleaned' => $cleaned];
    }

    /**
     * Validate phone number
     */
    public static function validatePhone($phone, $fieldName)
    {
        if (empty(trim($phone))) {
            return ['valid' => true]; // Allow empty
        }
        $cleaned = preg_replace('/\D/', '', trim($phone)); // فقط اعداد
        if (strlen($cleaned) !== 10) {
            return ['valid' => false, 'message' => "$fieldName باید دقیقاً 10 رقم باشد (بدون صفر اول)"];
        }
        if (substr($cleaned, 0, 1) === '0') {
            return ['valid' => false, 'message' => "$fieldName نباید با صفر شروع شود"];
        }
        return ['valid' => true, 'cleaned' => $cleaned];
    }
}

