<?php
/**
 * Application Bootstrap
 * Initializes all dependencies
 */

use App\Database\Connection;
use App\Database\Migration;
use App\Repositories\ConfigRepository;
use App\Repositories\UserRepository;
use App\Repositories\PersonRepository;
use App\Repositories\DealRepository;
use App\Repositories\ActivityRepository;
use App\Repositories\VirtualStageRepository;
use App\Repositories\SatisfactionRepository;
use App\Repositories\NotificationRepository;
use App\Repositories\ActivityReminderRepository;
use App\Repositories\ProductRepository;
use App\Repositories\AuditLogRepository;
use App\Repositories\LookupRepository;
use App\Repositories\FieldConfigRepository;
use App\Repositories\FieldAuditLogRepository;
use App\Repositories\KpiRepository;
use App\Repositories\SupportRepository;
use App\Services\DidarApiService;
use App\Services\AuthService;
use App\Services\AuditService;
use App\Services\VirtualStageService;
use App\Services\SyncService;
use App\Services\LeadService;
use App\Services\DealService;
use App\Services\ActivityService;
use App\Services\PipelineService;
use App\Services\NotificationService;
use App\Services\ExportService;
use App\Services\FieldPermissionService;
use App\Services\KpiService;
use App\Services\SupportService;
use App\Middleware\AuthMiddleware;
use App\Middleware\RoleMiddleware;

// Initialize database
$db = Connection::getInstance();

// Run migrations
$migration = new Migration($db);
$migration->run();

// Initialize repositories
$configRepo = new ConfigRepository($db);
$userRepo = new UserRepository($db);
$personRepo = new PersonRepository($db);
$dealRepo = new DealRepository($db);
$activityRepo = new ActivityRepository($db);
$virtualStageRepo = new VirtualStageRepository($db);
$satisfactionRepo = new SatisfactionRepository($db);
$notificationRepo = new NotificationRepository($db);
$activityReminderRepo = new ActivityReminderRepository($db);
$productRepo = new ProductRepository($db);
$auditLogRepo = new AuditLogRepository($db);
$lookupRepo = new LookupRepository($db);
$fieldConfigRepo = new FieldConfigRepository($db);
$fieldAuditLogRepo = new FieldAuditLogRepository($db);
$kpiRepo = new KpiRepository($db);
$supportRepo = new SupportRepository($db);

// Initialize services
$didarApiService = new DidarApiService($configRepo);
$authService = new AuthService($userRepo);
$virtualStageService = new VirtualStageService($virtualStageRepo, $activityRepo, $dealRepo, $personRepo);
$notificationService = new NotificationService($notificationRepo, $activityReminderRepo);
$syncService = new SyncService($didarApiService, $userRepo, $personRepo, $dealRepo, $activityRepo, $configRepo, $virtualStageService, $db);
$leadService = new LeadService($personRepo, $virtualStageRepo, $dealRepo, $virtualStageService, $didarApiService, $configRepo, $notificationService);
$dealService = new DealService($dealRepo, $personRepo, $didarApiService, $productRepo, $db, $lookupRepo);
$activityService = new ActivityService($activityRepo, $personRepo, $didarApiService, $configRepo, $virtualStageService, $notificationService);
$pipelineService = new PipelineService($didarApiService, $configRepo, $db);
$auditService = new AuditService($auditLogRepo, $fieldAuditLogRepo);
$exportService = new ExportService($db);
$fieldPermService = new FieldPermissionService($fieldConfigRepo, $lookupRepo);
$kpiService = new KpiService($kpiRepo, $userRepo);
$supportService = new SupportService($supportRepo);

// Initialize middleware
$authMiddleware = new AuthMiddleware($authService);
$roleMiddleware = new RoleMiddleware($authService);

// Return container-like object
return (object)[
    'db' => $db,
    'repositories' => (object)[
        'config' => $configRepo,
        'user' => $userRepo,
        'person' => $personRepo,
        'deal' => $dealRepo,
        'activity' => $activityRepo,
        'virtualStage' => $virtualStageRepo,
        'satisfaction' => $satisfactionRepo,
        'notification' => $notificationRepo,
        'activityReminder' => $activityReminderRepo,
        'product' => $productRepo,
        'auditLog' => $auditLogRepo,
        'lookup' => $lookupRepo,
        'fieldConfig' => $fieldConfigRepo,
        'fieldAuditLog' => $fieldAuditLogRepo,
        'kpi' => $kpiRepo,
        'support' => $supportRepo,
    ],
    'services' => (object)[
        'didarApi' => $didarApiService,
        'auth' => $authService,
        'virtualStage' => $virtualStageService,
        'sync' => $syncService,
        'lead' => $leadService,
        'deal' => $dealService,
        'activity' => $activityService,
        'pipeline' => $pipelineService,
        'notification' => $notificationService,
        'audit' => $auditService,
        'export' => $exportService,
        'fieldPermission' => $fieldPermService,
        'kpi' => $kpiService,
        'support' => $supportService,
    ],
    'middleware' => (object)[
        'auth' => $authMiddleware,
        'role' => $roleMiddleware,
    ],
];

