-- ============================================
-- MIGRATION: Create CRM Support Logs Table
-- Database: MySQL/MariaDB
-- ============================================
-- تاریخ: 2026-01-07
-- ============================================

CREATE TABLE IF NOT EXISTS `crm_support_logs` (
    `id` INT(11) NOT NULL AUTO_INCREMENT,
    `contact_didar_id` VARCHAR(100) NOT NULL COMMENT 'شناسه لید در دیدار',
    `channel` VARCHAR(50) NOT NULL DEFAULT 'call' COMMENT 'نوع کانال: call, chat, visit, email',
    `direction` VARCHAR(20) NOT NULL DEFAULT 'incoming' COMMENT 'جهت: incoming, outgoing',
    `result_note` TEXT DEFAULT NULL COMMENT 'نتیجه و توضیحات پشتیبانی',
    `created_by_didar_id` VARCHAR(100) NOT NULL COMMENT 'شناسه کاربر ثبت‌کننده',
    `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'زمان ایجاد',
    `updated_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'زمان آخرین ویرایش',
    PRIMARY KEY (`id`),
    KEY `idx_support_logs_contact` (`contact_didar_id`),
    KEY `idx_support_logs_created_at` (`created_at` DESC),
    KEY `idx_support_logs_created_by` (`created_by_didar_id`),
    CONSTRAINT `fk_support_logs_contact` 
        FOREIGN KEY (`contact_didar_id`) 
        REFERENCES `persons` (`didar_contact_id`) 
        ON DELETE CASCADE 
        ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='لاگ‌های پشتیبانی CRM';

-- ============================================
-- توضیحات فیلدها:
-- ============================================
-- id: شناسه یکتا
-- contact_didar_id: شناسه لید (FK to persons.didar_contact_id)
-- channel: نوع کانال (تماس، چت، حضوری، ایمیل)
-- direction: جهت (ورودی، خروجی)
-- result_note: نتیجه و توضیحات پشتیبانی
-- created_by_didar_id: شناسه کاربری که ثبت کرده
-- created_at: زمان ایجاد (خودکار)
-- updated_at: زمان آخرین ویرایش (خودکار)
-- 
-- دسترسی‌ها:
-- - CRM specialist: فقط ثبت (create)
-- - Admin: ثبت، ویرایش، حذف
-- - Agent: بدون دسترسی
-- ============================================



