-- ============================================
-- Fix Decimal Precision for Financial Amounts
-- Date: 2025-01-04
-- Description: Changes DOUBLE to DECIMAL(15,2) for precise financial calculations
-- ============================================

-- IMPORTANT: Before running this migration, ensure all NULL values are set to 0
-- Run this first:
-- UPDATE deals SET payable_amount = 0 WHERE payable_amount IS NULL;
-- UPDATE deals SET final_price = 0 WHERE final_price IS NULL;
-- UPDATE deals SET estimated_price = 0 WHERE estimated_price IS NULL;
-- UPDATE deals SET discount_amount = 0 WHERE discount_amount IS NULL;
-- UPDATE deals SET refund_amount = 0 WHERE refund_amount IS NULL;

-- deals table: Change DOUBLE to DECIMAL(15,2)
ALTER TABLE deals
MODIFY COLUMN payable_amount DECIMAL(15,2) NOT NULL DEFAULT 0,
MODIFY COLUMN final_price DECIMAL(15,2) DEFAULT 0,
MODIFY COLUMN estimated_price DECIMAL(15,2) DEFAULT 0,
MODIFY COLUMN discount_amount DECIMAL(15,2) DEFAULT 0,
MODIFY COLUMN refund_amount DECIMAL(15,2) DEFAULT 0;

-- Note: This migration will improve precision and prevent rounding errors
-- All existing data will be automatically converted by MySQL





