<?php
// Run this via browser: /run_migration_audit.php?key=secret123

if (php_sapi_name() !== 'cli' && ($_GET['key'] ?? '') !== 'secret123') {
    die('Access Denied');
}

require_once __DIR__ . '/../vendor/autoload.php';
$app = require_once __DIR__ . '/../app/bootstrap.php';

use App\Database\Connection;

$pdo = $app->db->getPdo();

echo "Adding related_person_didar_id to audit_logs table...<br>";

try {
    // Check if column exists
    $stmt = $pdo->query("SHOW COLUMNS FROM audit_logs LIKE 'related_person_didar_id'");
    if ($stmt->fetch()) {
        echo "Column 'related_person_didar_id' already exists.<br>";
    } else {
        $sql = "ALTER TABLE audit_logs ADD COLUMN related_person_didar_id VARCHAR(255) NULL AFTER entity_id";
        $pdo->exec($sql);
        echo "Column 'related_person_didar_id' added successfully.<br>";
        
        // Add index
        $pdo->exec("CREATE INDEX idx_related_person_didar_id ON audit_logs(related_person_didar_id)");
        echo "Index added successfully.<br>";
    }
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "<br>";
}
echo "Done.";
