#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
بررسی و آنالیز دیتابیس فعلی و فایل اکسل
"""

import sqlite3
import pandas as pd
import json
import sys
from pathlib import Path

# تنظیم encoding برای Windows
if sys.platform == 'win32':
    import io
    sys.stdout = io.TextIOWrapper(sys.stdout.buffer, encoding='utf-8')
    sys.stderr = io.TextIOWrapper(sys.stderr.buffer, encoding='utf-8')

# مسیر فایل‌ها
DB_PATH = "crm_database (5).db"
EXCEL_PATH = "پایگاه داده با فروش قبلی.xlsx"

print("=" * 60)
print("بررسی دیتابیس فعلی")
print("=" * 60)

# بررسی دیتابیس
conn = sqlite3.connect(DB_PATH)
cursor = conn.cursor()

# لیست جداول
cursor.execute("SELECT name FROM sqlite_master WHERE type='table'")
tables = [row[0] for row in cursor.fetchall()]
print(f"\nجداول موجود: {tables}")

# بررسی جدول users
print("\n" + "-" * 60)
print("جدول users:")
cursor.execute("PRAGMA table_info(users)")
columns = cursor.fetchall()
print("ستون‌ها:")
for col in columns:
    print(f"  {col[1]} ({col[2]})")

cursor.execute("SELECT COUNT(*) FROM users")
user_count = cursor.fetchone()[0]
print(f"\nتعداد کاربران: {user_count}")

cursor.execute("SELECT id, display_name, didar_user_id, role FROM users LIMIT 10")
print("\nنمونه کاربران:")
for row in cursor.fetchall():
    print(f"  ID: {row[0]}, Name: {row[1]}, Didar ID: {row[2]}, Role: {row[3]}")

# بررسی جدول persons
print("\n" + "-" * 60)
print("جدول persons:")
cursor.execute("PRAGMA table_info(persons)")
columns = cursor.fetchall()
print("ستون‌ها:")
for col in columns:
    print(f"  {col[1]} ({col[2]})")

cursor.execute("SELECT COUNT(*) FROM persons")
person_count = cursor.fetchone()[0]
print(f"\nتعداد اشخاص: {person_count}")

cursor.execute("SELECT didar_contact_id, first_name, last_name, owner_didar_id, mobile_phone FROM persons LIMIT 5")
print("\nنمونه اشخاص:")
for row in cursor.fetchall():
    print(f"  Didar ID: {row[0]}, Name: {row[1]} {row[2]}, Owner: {row[3]}, Mobile: {row[4]}")

# بررسی جدول virtual_stages
print("\n" + "-" * 60)
print("جدول virtual_stages:")
cursor.execute("PRAGMA table_info(virtual_stages)")
columns = cursor.fetchall()
print("ستون‌ها:")
for col in columns:
    print(f"  {col[1]} ({col[2]})")

cursor.execute("SELECT COUNT(*) FROM virtual_stages")
vs_count = cursor.fetchone()[0]
print(f"\nتعداد virtual stages: {vs_count}")

cursor.execute("SELECT DISTINCT stage_name FROM virtual_stages")
stages = [row[0] for row in cursor.fetchall()]
print(f"\nمراحل موجود: {stages}")

# بررسی جدول deals
print("\n" + "-" * 60)
print("جدول deals:")
cursor.execute("SELECT COUNT(*) FROM deals")
deal_count = cursor.fetchone()[0]
print(f"\nتعداد معاملات: {deal_count}")

conn.close()

print("\n" + "=" * 60)
print("آنالیز فایل اکسل")
print("=" * 60)

# خواندن فایل اکسل
try:
    df = pd.read_excel(EXCEL_PATH)
    print(f"\nتعداد ردیف‌ها: {len(df)}")
    print(f"تعداد ستون‌ها: {len(df.columns)}")
    
    print("\nستون‌های موجود:")
    for i, col in enumerate(df.columns):
        print(f"  {i+1}. {col}")
    
    print("\nنمونه داده‌ها (5 ردیف اول):")
    print(df.head().to_string())
    
    # بررسی ستون "داری فروش قبلی"
    purchase_col = None
    for col in df.columns:
        if 'فروش' in str(col) or 'خرید' in str(col) or 'purchase' in str(col).lower():
            purchase_col = col
            break
    
    if purchase_col:
        print(f"\nستون مربوط به فروش قبلی: {purchase_col}")
        print(f"مقادیر منحصر به فرد: {df[purchase_col].unique()}")
        print(f"تعداد 'بله': {len(df[df[purchase_col].astype(str).str.contains('بله|yes', case=False, na=False)])}")
        print(f"تعداد 'خیر': {len(df[df[purchase_col].astype(str).str.contains('خیر|no', case=False, na=False)])}")
    else:
        print("\n⚠️ ستون 'داری فروش قبلی' پیدا نشد!")
        print("لطفاً نام دقیق ستون را بررسی کنید.")
    
    # بررسی ستون‌های مربوط به کاربر/مالک
    owner_cols = []
    for col in df.columns:
        if 'کاربر' in str(col) or 'مالک' in str(col) or 'owner' in str(col).lower() or 'user' in str(col).lower():
            owner_cols.append(col)
    
    if owner_cols:
        print(f"\nستون‌های مربوط به کاربر/مالک: {owner_cols}")
    else:
        print("\n⚠️ ستون مربوط به کاربر/مالک پیدا نشد!")
    
    # بررسی ستون‌های مربوط به تماس/شماره
    contact_cols = []
    for col in df.columns:
        if 'تماس' in str(col) or 'شماره' in str(col) or 'موبایل' in str(col) or 'mobile' in str(col).lower() or 'phone' in str(col).lower():
            contact_cols.append(col)
    
    if contact_cols:
        print(f"\nستون‌های مربوط به تماس/شماره: {contact_cols}")
    
    # بررسی ستون‌های مربوط به نام
    name_cols = []
    for col in df.columns:
        if 'نام' in str(col) or 'name' in str(col).lower():
            name_cols.append(col)
    
    if name_cols:
        print(f"\nستون‌های مربوط به نام: {name_cols}")
    
except Exception as e:
    print(f"\n❌ خطا در خواندن فایل اکسل: {e}")
    import traceback
    traceback.print_exc()

print("\n" + "=" * 60)
print("بررسی تکمیل شد")
print("=" * 60)

