<?php
/**
 * تحلیل کامل دیتابیس SQLite برای مهاجرت به MySQL
 */

$dbFile = __DIR__ . '/crm_database.db';

if (!file_exists($dbFile)) {
    die("دیتابیس یافت نشد: $dbFile\n");
}

try {
    $pdo = new PDO("sqlite:$dbFile");
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    $report = [];
    
    // 1. لیست جداول
    $tables = $pdo->query("SELECT name FROM sqlite_master WHERE type='table' AND name NOT LIKE 'sqlite_%' ORDER BY name")
        ->fetchAll(PDO::FETCH_COLUMN);
    
    $report['tables'] = [];
    
    foreach ($tables as $table) {
        // ساختار جدول
        $columns = $pdo->query("PRAGMA table_info($table)")->fetchAll(PDO::FETCH_ASSOC);
        
        // ایندکس‌ها
        $indexes = $pdo->query("SELECT name, sql FROM sqlite_master WHERE type='index' AND tbl_name='$table' AND sql IS NOT NULL")
            ->fetchAll(PDO::FETCH_ASSOC);
        
        // تعداد رکوردها
        $rowCount = $pdo->query("SELECT COUNT(*) FROM $table")->fetchColumn();
        
        // SQL ساخت جدول
        $createTable = $pdo->query("SELECT sql FROM sqlite_master WHERE type='table' AND name='$table'")
            ->fetchColumn();
        
        $report['tables'][$table] = [
            'columns' => $columns,
            'indexes' => $indexes,
            'row_count' => $rowCount,
            'create_sql' => $createTable
        ];
    }
    
    // 2. بررسی Foreign Keys (اگر وجود داشته باشد)
    $report['foreign_keys'] = [];
    foreach ($tables as $table) {
        $fks = $pdo->query("PRAGMA foreign_key_list($table)")->fetchAll(PDO::FETCH_ASSOC);
        if (!empty($fks)) {
            $report['foreign_keys'][$table] = $fks;
        }
    }
    
    // 3. ذخیره گزارش
    file_put_contents(__DIR__ . '/database_analysis_report.json', json_encode($report, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    
    // 4. نمایش خلاصه
    echo "=== تحلیل دیتابیس ===\n\n";
    echo "تعداد جداول: " . count($tables) . "\n\n";
    
    foreach ($tables as $table) {
        $info = $report['tables'][$table];
        echo "جدول: $table\n";
        echo "  - تعداد ستون‌ها: " . count($info['columns']) . "\n";
        echo "  - تعداد رکوردها: " . $info['row_count'] . "\n";
        echo "  - تعداد ایندکس‌ها: " . count($info['indexes']) . "\n";
        echo "\n";
    }
    
    echo "گزارش کامل در فایل database_analysis_report.json ذخیره شد.\n";
    
} catch (PDOException $e) {
    die("خطا: " . $e->getMessage() . "\n");
}


