#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""بررسی عمیق مشکل نمایش لیدها"""

import sqlite3

DB_FILE = 'crm_database_zahoori.db'

conn = sqlite3.connect(DB_FILE)
cursor = conn.cursor()

print("=" * 70)
print("گزارش بررسی عمیق")
print("=" * 70)

# 1. بررسی کاربر ظهوری
print("\n1. بررسی didar_user_id کاربر ظهوری:")
print("-" * 70)
zahoori = cursor.execute("""
    SELECT id, didar_user_id, display_name, role 
    FROM users 
    WHERE display_name LIKE '%ظهوری%'
""").fetchone()

if zahoori:
    print(f"✅ کاربر پیدا شد:")
    print(f"   ID: {zahoori[0]}")
    print(f"   didar_user_id: {zahoori[1]}")
    print(f"   display_name: {zahoori[2]}")
    print(f"   role: {zahoori[3]}")
    zahoori_didar_id = zahoori[1]
else:
    print("❌ کاربر ظهوری پیدا نشد!")
    zahoori_didar_id = None

# 2. بررسی owner_didar_id لیدها
print("\n2. بررسی owner_didar_id لیدها:")
print("-" * 70)
owner_counts = cursor.execute("""
    SELECT DISTINCT owner_didar_id, COUNT(*) as cnt 
    FROM persons 
    GROUP BY owner_didar_id
""").fetchall()

print("توزیع owner_didar_id:")
for oc in owner_counts:
    print(f"   {oc[0]}: {oc[1]} لید")
    owner_id = oc[0]
    
    # بررسی اینکه آیا این owner_didar_id در جدول users وجود دارد
    user = cursor.execute("""
        SELECT display_name, role 
        FROM users 
        WHERE didar_user_id = ?
    """, (owner_id,)).fetchone()
    
    if user:
        print(f"      → متعلق به: {user[0]} ({user[1]})")
    else:
        print(f"      → ⚠️ هیچ کاربری با این didar_user_id پیدا نشد!")

# 3. بررسی تطابق
print("\n3. بررسی تطابق:")
print("-" * 70)
if zahoori_didar_id and owner_counts:
    owner_id_in_leads = owner_counts[0][0]
    
    print(f"didar_user_id کاربر ظهوری: {zahoori_didar_id}")
    print(f"owner_didar_id لیدها: {owner_id_in_leads}")
    
    match = zahoori_didar_id == owner_id_in_leads
    print(f"\nتطابق: {'✅ بله' if match else '❌ خیر'}")
    
    if not match:
        print(f"\n❌ مشکل: didar_user_id ≠ owner_didar_id")
        print(f"   تفاوت: {zahoori_didar_id} ≠ {owner_id_in_leads}")
    
    # Query برای کاربر ظهوری
    count = cursor.execute("""
        SELECT COUNT(*) 
        FROM persons 
        WHERE owner_didar_id = ?
    """, (zahoori_didar_id,)).fetchone()[0]
    
    print(f"\nتعداد لیدهایی که باید برای کاربر ظهوری نمایش داده شوند: {count}")

# 4. بررسی کاربر حنفی
print("\n4. بررسی کاربر حنفی (ادمین):")
print("-" * 70)
hanafi = cursor.execute("""
    SELECT id, didar_user_id, display_name, role 
    FROM users 
    WHERE display_name LIKE '%حنفی%' OR role = 'admin'
    ORDER BY role DESC
    LIMIT 1
""").fetchone()

if hanafi:
    print(f"✅ کاربر پیدا شد:")
    print(f"   ID: {hanafi[0]}")
    print(f"   didar_user_id: {hanafi[1]}")
    print(f"   display_name: {hanafi[2]}")
    print(f"   role: {hanafi[3]}")
    
    # بررسی تطابق
    if owner_counts:
        owner_id_list = [o[0] for o in owner_counts]
        match_hanafi = hanafi[1] in owner_id_list
        print(f"\nتطابق با owner_didar_id لیدها: {'✅ بله' if match_hanafi else '❌ خیر (اما ادمین است پس همه را می‌بیند)'}")

# 5. شبیه‌سازی Query
print("\n5. شبیه‌سازی Query برای کاربر ظهوری:")
print("-" * 70)
if zahoori_didar_id:
    print(f"didar_id در session (فرضی): {zahoori_didar_id}")
    print("isAdmin: False")
    print(f"didarId empty: {not zahoori_didar_id}")
    print("\nQuery: SELECT COUNT(*) FROM persons WHERE didar_contact_id IS NOT NULL AND owner_didar_id = ?")
    
    count = cursor.execute("""
        SELECT COUNT(*) 
        FROM persons 
        WHERE didar_contact_id IS NOT NULL 
        AND owner_didar_id = ?
    """, (zahoori_didar_id,)).fetchone()[0]
    
    print(f"\nنتیجه: {count} لید")
    
    if count == 0:
        print("\n❌ مشکل: Query هیچ لیدی برنمی‌گرداند!")
        print("   این یعنی owner_didar_id لیدها با didar_user_id کاربر مطابقت ندارد")

# 6. شبیه‌سازی Query برای ادمین
print("\n6. شبیه‌سازی Query برای ادمین:")
print("-" * 70)
print("Query: SELECT COUNT(*) FROM persons WHERE didar_contact_id IS NOT NULL")
count_admin = cursor.execute("""
    SELECT COUNT(*) 
    FROM persons 
    WHERE didar_contact_id IS NOT NULL
""").fetchone()[0]
print(f"نتیجه: {count_admin} لید")

# 7. بررسی همه کاربران و لیدهایشان
print("\n7. بررسی همه didar_user_id های موجود در users:")
print("-" * 70)
users = cursor.execute("""
    SELECT didar_user_id, display_name, role 
    FROM users 
    ORDER BY display_name
""").fetchall()

for u in users:
    count_leads = cursor.execute("""
        SELECT COUNT(*) 
        FROM persons 
        WHERE owner_didar_id = ?
    """, (u[0],)).fetchone()[0]
    
    status = "✅" if count_leads > 0 else "❌"
    print(f"   {status} {u[0]}: {u[1]} ({u[2]}) -> {count_leads} لید")

# 8. نتیجه‌گیری
print("\n8. نتیجه‌گیری:")
print("-" * 70)

if zahoori_didar_id and owner_counts:
    owner_id_in_leads = owner_counts[0][0]
    
    if zahoori_didar_id != owner_id_in_leads:
        print("❌ مشکل اصلی:")
        print(f"   didar_user_id کاربر ظهوری ({zahoori_didar_id})")
        print(f"   با owner_didar_id لیدها ({owner_id_in_leads}) مطابقت ندارد")
        print("\n💡 راه حل:")
        print(f"   باید didar_user_id کاربر ظهوری را به '{owner_id_in_leads}' تغییر دهید")
    else:
        print("✅ تطابق کامل است!")
        print("   مشکل در جای دیگری است (احتمالاً session یا کد PHP)")

conn.close()

print("\n" + "=" * 70)
print("بررسی کامل شد")
print("=" * 70)

