    -- ============================================
    -- Simple Debug: Check Deal and Transaction Data
    -- Date: January 4, 2025
    -- Purpose: Find most recent deal and verify payment data
    -- ============================================

    -- Step 1: Find most recent deal
    SELECT 
        '=== RECENT DEAL ===' as section,
        'Deal ID' as deal_id,
        'Didar Deal ID' as didar_deal_id,
        'Title' as title,
        'Status' as status,
        'Payable Amount' as payable_amount,
        'Payment Amount' as payment_amount,
        'Register Time' as register_time
        'Owner ID' as owner_didar_id,
        'Contact ID' as contact_didar_id
    FROM deals 
    WHERE id = (
        SELECT MAX(id) FROM deals
    )
    ORDER BY register_time DESC
    LIMIT 1;

    -- Step 2: Show all payments for this deal
    SELECT 
        '=== ALL PAYMENTS FOR DEAL ===' as section,
        'Transaction ID' as trans_id,
        'Deal ID' as deal_id,
        'Amount' as amount,
        'Payment Date' as payment_date,
        'Payment Time' as payment_time,
        'Is First Payment' as is_first_payment,
        'Status' as status
    FROM transactions 
    WHERE deal_id = (
        SELECT id FROM deals 
        WHERE didar_deal_id LIKE 'RECENT%'
        ORDER BY register_time DESC
        LIMIT 1
    )
    ORDER BY payment_date, payment_time;

    -- Step 3: Check what KPI filters are in effect
    SELECT 
        '=== CURRENT KPI FILTER ===' as section,
        'User Didar ID' as session_id,
        'Date From' as date_from,
        'Date To' as date_to
    FROM (
        SELECT 'session_id' as filter_value 
        FROM (
            SELECT 'Current Date Filter' as description, 
                CONCAT('date_from=', DATE_FORMAT(SUBTIME(CURRENT_DATE, INTERVAL 1 MONTH), '%Y-%m-%d')) as filter_value
            UNION
            SELECT 'Current Date Filter' as description, 
                CONCAT('date_to=', DATE_FORMAT(LAST_DAY(CURRENT_DATE), '%Y-%m-%d')) as filter_value
        )
    );

    -- Step 4: Simple KPI check for this deal
    SELECT 
        '=== KPI CHECK FOR THIS DEAL ===' as section,
        'Would be in Sales KPI?' as sales_check,
        'Has confirmed first payment?' as first_payment_check,
        'Payable Amount' as payable_amount,
        'Total Collected' as collected,
        'Would be Settled?' as settled_check
        'Would be Outstanding?' as outstanding_check
    FROM deals d
    LEFT JOIN (
        SELECT 
            t.deal_id,
            SUM(t.amount) as total_collected,
            COUNT(*) as payment_count
        FROM transactions t
        WHERE t.deal_id = (
            SELECT id FROM deals 
            WHERE didar_deal_id LIKE 'RECENT%'
            ORDER BY register_time DESC
            LIMIT 1
        )
        AND t.status = 'confirmed'
    )
    WHERE d.id = (
        SELECT id FROM deals 
        WHERE didar_deal_id LIKE 'RECENT%'
        ORDER BY register_time DESC
        LIMIT 1
    );





