<?php
/**
 * Extract JavaScript from index.php
 */

$indexFile = __DIR__ . '/../index.php';
$outputFile = __DIR__ . '/../assets/js/app.js';

if (!file_exists($indexFile)) {
    die("index.php not found!\n");
}

$content = file_get_contents($indexFile);

// Find JavaScript section (between <script> and </script>)
$startPos = strpos($content, '<script>');
$endPos = strpos($content, '</script>', $startPos);

if ($startPos === false || $endPos === false) {
    die("JavaScript section not found!\n");
}

// Extract JavaScript (skip <script> tag itself)
$startPos += strlen('<script>');
$jsCode = substr($content, $startPos, $endPos - $startPos);

// Remove PHP code blocks and replace with placeholders/comments
// Pattern 1: const APP_USER = <?php echo json_encode([...]); ?>;
$jsCode = preg_replace(
    '/const APP_USER = <\?php echo json_encode\(\[.*?\]\); \?>;/s',
    "// APP_USER will be defined in layout\nconst APP_USER = window.APP_USER || { role: 'guest', didar_id: null, name: '' };",
    $jsCode
);

// Pattern 2: <?php echo $_SESSION['user_id'] ?? 0; ?>
$jsCode = preg_replace(
    '/<\?php echo \$_SESSION\[\'user_id\'\] \?\? 0; \?>/',
    'window.CURRENT_USER_ID || 0',
    $jsCode
);

// Pattern 3: <?php echo ($_SESSION['role'] ?? '') === 'admin' ? 'true' : 'false'; ?>
$jsCode = preg_replace(
    '/<\?php echo \(\$_SESSION\[\'role\'\] \?\? \'\'\) === \'admin\' \? \'true\' : \'false\'; \?>/',
    "(window.APP_USER?.role === 'admin') ? 'true' : 'false'",
    $jsCode
);

// Pattern 4: <?php echo $_SESSION['role'] ?? ''; ?>
$jsCode = preg_replace(
    '/<\?php echo \$_SESSION\[\'role\'\] \?\? \'\'; \?>/',
    "window.APP_USER?.role || ''",
    $jsCode
);

// Pattern 5: <?php echo addslashes($_SESSION['name'] ?? ''); ?>
$jsCode = preg_replace(
    '/<\?php echo addslashes\(\$_SESSION\[\'name\'\] \?\? \'\'\); \?>/',
    "(window.APP_USER?.name || '').replace(/'/g, \"\\\\'\")",
    $jsCode
);

// Pattern 6: <?php if(isset($_SESSION['user_id'])): ?>
$jsCode = preg_replace(
    '/<\?php if\(isset\(\$_SESSION\[\'user_id\'\)\): \?>/',
    "if (window.APP_USER && window.CURRENT_USER_ID) {",
    $jsCode
);

// Pattern 7: <?php if($_SESSION['role'] === 'admin'): ?>
$jsCode = preg_replace(
    '/<\?php if\(\$_SESSION\[\'role\'\] === \'admin\'\): \?>/',
    "if (window.APP_USER?.role === 'admin') {",
    $jsCode
);

// Pattern 8: <?php endif; ?>
$jsCode = preg_replace(
    '/<\?php endif; \?>/',
    "}",
    $jsCode
);

// Pattern 9: <?php echo $_SESSION['user_id'] ?? 0; ?> (in different contexts)
$jsCode = preg_replace(
    '/window\.currentUserId \|\| <\?php echo \$_SESSION\[\'user_id\'\] \?\? 0; \?>/',
    'window.CURRENT_USER_ID || 0',
    $jsCode
);

// Clean up any remaining PHP tags (just in case)
$jsCode = preg_replace('/<\?php.*?\?>/s', '/* PHP code removed */', $jsCode);

// Ensure directory exists
$outputDir = dirname($outputFile);
if (!is_dir($outputDir)) {
    mkdir($outputDir, 0755, true);
}

// Write to file
file_put_contents($outputFile, $jsCode);

echo "JavaScript extracted successfully to: $outputFile\n";
echo "Size: " . number_format(strlen($jsCode)) . " bytes\n";
echo "Lines: " . substr_count($jsCode, "\n") . "\n";

