<?php
/**
 * Migration: Add customer level fields to persons table
 */

require_once __DIR__ . '/../../app/bootstrap.php';

$app = require __DIR__ . '/../../app/bootstrap.php';
$pdo = $app->db->getPdo();

echo "Starting migration: Add customer level fields to persons table\n";

try {
    // Check if columns already exist
    $stmt = $pdo->query("SHOW COLUMNS FROM persons LIKE 'customer_level'");
    $customerLevelExists = $stmt->rowCount() > 0;

    $stmt = $pdo->query("SHOW COLUMNS FROM persons LIKE 'customer_level_notes'");
    $customerLevelNotesExists = $stmt->rowCount() > 0;

    if ($customerLevelExists && $customerLevelNotesExists) {
        echo "✅ Customer level fields already exist\n";
        exit(0);
    }

    // Add customer_level column if not exists
    if (!$customerLevelExists) {
        echo "Adding customer_level column...\n";
        $pdo->exec("ALTER TABLE persons ADD COLUMN customer_level ENUM('طلایی', 'نقره‌ای', 'برنز') DEFAULT NULL AFTER requested_services");
        echo "✅ customer_level column added\n";
    }

    // Add customer_level_notes column if not exists
    if (!$customerLevelNotesExists) {
        echo "Adding customer_level_notes column...\n";
        $pdo->exec("ALTER TABLE persons ADD COLUMN customer_level_notes TEXT AFTER customer_level");
        echo "✅ customer_level_notes column added\n";
    }

    echo "✅ Migration completed successfully!\n";

} catch (Exception $e) {
    echo "❌ Migration failed: " . $e->getMessage() . "\n";
    exit(1);
}