<?php
require_once __DIR__ . '/../../app/bootstrap.php';

use App\Database\Connection;
use App\Utils\Logger;

echo "Starting migration: Adding missing columns to persons table...\n";

try {
    $db = new Connection();
    $pdo = $db->getPdo();

    $columnsToAdd = [
        'job_description' => 'TEXT',
        'acquaintance_duration' => 'VARCHAR(100)',
        'extra_info' => 'TEXT',
        'financial_level' => 'VARCHAR(100)',
        'asset_estimation' => 'VARCHAR(100)',
        'income_estimation' => 'VARCHAR(100)',
        'requested_services' => 'TEXT'
    ];

    foreach ($columnsToAdd as $column => $definition) {
        // Check if column exists
        $check = $pdo->prepare("SHOW COLUMNS FROM persons LIKE ?");
        $check->execute([$column]);
        
        if ($check->rowCount() === 0) {
            echo "Adding column '$column'...\n";
            $sql = "ALTER TABLE persons ADD COLUMN $column $definition";
            
            // Try to place it nicely if possible, but simple append is safer/easier across versions
            // We'll just append it.
            
            $pdo->exec($sql);
            echo "Column '$column' added successfully.\n";
        } else {
            echo "Column '$column' already exists.\n";
        }
    }

    echo "Migration completed successfully.\n";

} catch (Exception $e) {
    echo "Migration failed: " . $e->getMessage() . "\n";
    Logger::logError("Migration failed", $e);
    exit(1);
}

