<?php
/**
 * Migration: اضافه کردن فیلد show_popup به جدول notifications
 * این فایل را یک بار اجرا کنید
 */

// بارگذاری تنظیمات دیتابیس
$config = require __DIR__ . '/../../app/config/database.php';

try {
    $dsn = sprintf(
        'mysql:host=%s;dbname=%s;charset=%s',
        $config['host'],
        $config['database'],
        $config['charset']
    );

    $pdo = new PDO($dsn, $config['username'], $config['password'], $config['options']);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (Exception $e) {
    die("❌ خطا در اتصال به دیتابیس: " . $e->getMessage());
}

header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html dir="rtl" lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Migration - اضافه کردن فیلد show_popup به جدول notifications</title>
    <style>
        body {
            font-family: 'Vazirmatn', 'Tahoma', sans-serif;
            background: #0f172a;
            color: #f8fafc;
            padding: 20px;
            max-width: 800px;
            margin: 0 auto;
        }
        .container {
            background: rgba(30, 41, 59, 0.8);
            backdrop-filter: blur(8px);
            border: 1px solid rgba(255,255,255,0.05);
            border-radius: 12px;
            padding: 30px;
        }
        h1 {
            color: #eab308;
            border-bottom: 2px solid #eab308;
            padding-bottom: 10px;
        }
        .success { color: #10b981; }
        .warning { color: #f59e0b; }
        .error { color: #ef4444; }
        .info { color: #3b82f6; }
        pre {
            background: #1e293b;
            padding: 15px;
            border-radius: 6px;
            overflow-x: auto;
            border: 1px solid #334155;
        }
        .step {
            margin: 15px 0;
            padding: 10px;
            background: rgba(255,255,255,0.05);
            border-radius: 6px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔄 Migration: اضافه کردن فیلد show_popup به جدول notifications</h1>

        <div class="step">
            <h2>📋 مراحل:</h2>
            <pre><?php

echo "🔄 شروع Migration...\n\n";

// 1. اضافه کردن ستون show_popup
echo "1️⃣ اضافه کردن ستون show_popup...\n";
try {
    $pdo->exec("ALTER TABLE notifications ADD COLUMN show_popup TINYINT(1) DEFAULT 1");
    echo "   ✅ ستون show_popup اضافه شد\n";
} catch (PDOException $e) {
    if (strpos($e->getMessage(), 'Duplicate column') !== false || strpos($e->getMessage(), 'already exists') !== false) {
        echo "   ⚠️ ستون show_popup از قبل وجود دارد\n";
    } else {
        echo "   ❌ خطا در اضافه کردن show_popup: " . $e->getMessage() . "\n";
    }
}

// 2. تنظیم مقدار پیش‌فرض برای رکوردهای موجود
echo "\n2️⃣ تنظیم مقدار پیش‌فرض برای رکوردهای موجود...\n";
try {
    $stmt = $pdo->prepare("UPDATE notifications SET show_popup = 1 WHERE show_popup IS NULL");
    $stmt->execute();
    $updated = $stmt->rowCount();
    echo "   ✅ مقدار پیش‌فرض برای {$updated} نوتیفیکیشن تنظیم شد\n";
} catch (PDOException $e) {
    echo "   ❌ خطا در تنظیم مقدار پیش‌فرض: " . $e->getMessage() . "\n";
}

// 3. بررسی نمونه نوتیفیکیشن‌ها
echo "\n3️⃣ بررسی نمونه نوتیفیکیشن‌ها:\n";
try {
    $notifications = $pdo->query("SELECT id, title, show_popup FROM notifications ORDER BY created_at DESC LIMIT 5")->fetchAll(PDO::FETCH_ASSOC);
    foreach ($notifications as $notif) {
        $popupStatus = $notif['show_popup'] ? '✅ پاپ‌آپ نمایش داده شود' : '❌ پاپ‌آپ نمایش داده نشود';
        echo "   ID {$notif['id']}: {$notif['title']} - {$popupStatus}\n";
    }
} catch (PDOException $e) {
    echo "   ❌ خطا در بررسی نوتیفیکیشن‌ها: " . $e->getMessage() . "\n";
}

// 4. بررسی ساختار جدول
echo "\n4️⃣ بررسی ساختار جدول notifications:\n";
try {
    $columns = $pdo->query("DESCRIBE notifications")->fetchAll(PDO::FETCH_ASSOC);
    $columnNames = array_column($columns, 'Field');
    $hasShowPopup = in_array('show_popup', $columnNames) ? '✅' : '❌';
    echo "   {$hasShowPopup} ستون show_popup: " . ($hasShowPopup === '✅' ? 'موجود' : 'وجود ندارد') . "\n";

    // نمایش همه ستون‌ها
    echo "   ستون‌های جدول:\n";
    foreach ($columns as $column) {
        echo "      - {$column['Field']} ({$column['Type']})\n";
    }
} catch (PDOException $e) {
    echo "   ❌ خطا در بررسی ساختار جدول: " . $e->getMessage() . "\n";
}

// 5. شمارش کل نوتیفیکیشن‌ها
echo "\n5️⃣ آمار نوتیفیکیشن‌ها:\n";
try {
    $total = $pdo->query("SELECT COUNT(*) FROM notifications")->fetchColumn();
    $withPopup = $pdo->query("SELECT COUNT(*) FROM notifications WHERE show_popup = 1")->fetchColumn();
    $withoutPopup = $pdo->query("SELECT COUNT(*) FROM notifications WHERE show_popup = 0")->fetchColumn();

    echo "   📊 مجموع نوتیفیکیشن‌ها: {$total}\n";
    echo "   🔔 با پاپ‌آپ: {$withPopup}\n";
    echo "   🔕 بدون پاپ‌آپ: {$withoutPopup}\n";
} catch (PDOException $e) {
    echo "   ❌ خطا در شمارش: " . $e->getMessage() . "\n";
}

echo "\n✅ Migration تکمیل شد!\n";
echo "💡 حالا سیستم نوتیفیکیشن از قابلیت پاپ‌آپ پشتیبانی می‌کند.\n";

?></pre>
        </div>

        <div class="step">
            <h2>📝 دستورالعمل:</h2>
            <ul>
                <li>✅ Migration با موفقیت اجرا شد</li>
                <li>🔔 فیلد show_popup به جدول notifications اضافه شد</li>
                <li>🔄 مقدار پیش‌فرض برای همه نوتیفیکیشن‌ها روی true تنظیم شد</li>
                <li>⚠️ <strong>این فایل را حذف کنید</strong> برای امنیت</li>
            </ul>
        </div>

        <div class="step">
            <h2>🔒 امنیت:</h2>
            <p class="warning">⚠️ لطفاً این فایل (add_notification_popup_field.php) را از سرور حذف کنید تا دیگران نتوانند آن را اجرا کنند.</p>
        </div>
    </div>
</body>
</html>
