<?php
/**
 * Migration: اضافه کردن ستون‌های username و password به جدول users
 * این فایل را یک بار اجرا کنید
 */

define('DB_FILE', __DIR__ . '/crm_database.db');

if (!file_exists(DB_FILE)) {
    die("❌ فایل دیتابیس یافت نشد: " . DB_FILE);
}

$pdo = new PDO('sqlite:' . DB_FILE);
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html dir="rtl" lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Migration - اضافه کردن ستون‌های username و password</title>
    <style>
        body {
            font-family: 'Vazirmatn', 'Tahoma', sans-serif;
            background: #0f172a;
            color: #f8fafc;
            padding: 20px;
            max-width: 800px;
            margin: 0 auto;
        }
        .container {
            background: rgba(30, 41, 59, 0.8);
            backdrop-filter: blur(8px);
            border: 1px solid rgba(255,255,255,0.05);
            border-radius: 12px;
            padding: 30px;
        }
        h1 {
            color: #eab308;
            border-bottom: 2px solid #eab308;
            padding-bottom: 10px;
        }
        .success { color: #10b981; }
        .warning { color: #f59e0b; }
        .error { color: #ef4444; }
        .info { color: #3b82f6; }
        pre {
            background: #1e293b;
            padding: 15px;
            border-radius: 6px;
            overflow-x: auto;
            border: 1px solid #334155;
        }
        .step {
            margin: 15px 0;
            padding: 10px;
            background: rgba(255,255,255,0.05);
            border-radius: 6px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔄 Migration: اضافه کردن ستون‌های username و password</h1>
        
        <div class="step">
            <h2>📋 مراحل:</h2>
            <pre><?php

echo "🔄 شروع Migration...\n\n";

// 1. اضافه کردن ستون username
echo "1️⃣ اضافه کردن ستون username...\n";
try { 
    $pdo->exec("ALTER TABLE users ADD COLUMN username TEXT"); 
    echo "   ✅ ستون username اضافه شد\n";
} catch (PDOException $e) {
    if (strpos($e->getMessage(), 'duplicate column') !== false || strpos($e->getMessage(), 'already exists') !== false) {
        echo "   ⚠️ ستون username از قبل وجود دارد\n";
    } else {
        echo "   ❌ خطا در اضافه کردن username: " . $e->getMessage() . "\n";
    }
}

// 2. اضافه کردن ستون password
echo "\n2️⃣ اضافه کردن ستون password...\n";
try { 
    $pdo->exec("ALTER TABLE users ADD COLUMN password TEXT"); 
    echo "   ✅ ستون password اضافه شد\n";
} catch (PDOException $e) {
    if (strpos($e->getMessage(), 'duplicate column') !== false || strpos($e->getMessage(), 'already exists') !== false) {
        echo "   ⚠️ ستون password از قبل وجود دارد\n";
    } else {
        echo "   ❌ خطا در اضافه کردن password: " . $e->getMessage() . "\n";
    }
}

// 3. تنظیم پسورد پیش‌فرض
echo "\n3️⃣ تنظیم پسورد پیش‌فرض (12345678)...\n";
$defaultPassword = password_hash('12345678', PASSWORD_DEFAULT);
$stmt = $pdo->prepare("UPDATE users SET password = ? WHERE password IS NULL OR password = ''");
$stmt->execute([$defaultPassword]);
$updated = $stmt->rowCount();
echo "   ✅ پسورد پیش‌فرض برای {$updated} کاربر تنظیم شد\n";

// 4. تنظیم username از display_name
echo "\n4️⃣ تنظیم username از display_name...\n";
try {
    $stmt = $pdo->prepare("UPDATE users SET username = display_name WHERE (username IS NULL OR username = '') AND display_name IS NOT NULL");
    $stmt->execute();
    $updated = $stmt->rowCount();
    echo "   ✅ username برای {$updated} کاربر تنظیم شد\n";
} catch (PDOException $e) {
    echo "   ⚠️ خطا در تنظیم username: " . $e->getMessage() . "\n";
}

// 5. بررسی نتیجه
echo "\n5️⃣ بررسی کاربران:\n";
$users = $pdo->query("SELECT id, display_name, username, password, role FROM users WHERE is_active = 1 ORDER BY role DESC, display_name LIMIT 10")->fetchAll(PDO::FETCH_ASSOC);
foreach ($users as $user) {
    $hasUsername = !empty($user['username']) ? '✅' : '❌';
    $hasPassword = !empty($user['password']) ? '✅' : '❌';
    $role = $user['role'] === 'admin' ? ' (مدیر)' : '';
    echo "   {$hasUsername} {$hasPassword} {$user['display_name']}{$role}\n";
    echo "      username: " . ($user['username'] ?: 'خالی') . "\n";
}

// 6. بررسی ساختار جدول
echo "\n6️⃣ بررسی ساختار جدول users:\n";
$columns = $pdo->query("PRAGMA table_info(users)")->fetchAll(PDO::FETCH_ASSOC);
$columnNames = array_column($columns, 'name');
$hasUsername = in_array('username', $columnNames) ? '✅' : '❌';
$hasPassword = in_array('password', $columnNames) ? '✅' : '❌';
echo "   {$hasUsername} ستون username: " . ($hasUsername === '✅' ? 'موجود' : 'وجود ندارد') . "\n";
echo "   {$hasPassword} ستون password: " . ($hasPassword === '✅' ? 'موجود' : 'وجود ندارد') . "\n";

echo "\n✅ Migration تکمیل شد!\n";
echo "💡 حالا می‌توانید با display_name و رمز عبور 12345678 لاگین کنید.\n";

?></pre>
        </div>
        
        <div class="step">
            <h2>📝 دستورالعمل:</h2>
            <ul>
                <li>✅ Migration با موفقیت اجرا شد</li>
                <li>🔐 پسورد پیش‌فرض برای همه کاربران: <strong>12345678</strong></li>
                <li>👤 Username برابر با display_name تنظیم شد</li>
                <li>⚠️ <strong>این فایل را حذف کنید</strong> برای امنیت</li>
            </ul>
        </div>
        
        <div class="step">
            <h2>🔒 امنیت:</h2>
            <p class="warning">⚠️ لطفاً این فایل (migrate.php) را از سرور حذف کنید تا دیگران نتوانند آن را اجرا کنند.</p>
        </div>
    </div>
</body>
</html>

