<?php
/**
 * Migration Script: اضافه کردن inactive_without_purchase به CHECK constraint
 * این script جدول virtual_stages را به‌روز می‌کند تا شامل 'inactive_without_purchase' و 'inactive_with_purchase' و 'refer_crm' باشد
 */

$dbFiles = [
    __DIR__ . '/crm_database.db',
    __DIR__ . '/crm_database (2).db',
    __DIR__ . '/crm_database (3).db'
];

$DB_FILE = null;
foreach ($dbFiles as $file) {
    if (file_exists($file)) {
        $DB_FILE = $file;
        break;
    }
}

if (!$DB_FILE) {
    die("دیتابیس یافت نشد.\n");
}

try {
    $pdo = new PDO('sqlite:' . $DB_FILE);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "=== Migration: اضافه کردن inactive_without_purchase به virtual_stages ===\n\n";
    
    // 1. بررسی اینکه آیا جدول وجود دارد
    $tableExists = $pdo->query("SELECT name FROM sqlite_master WHERE type='table' AND name='virtual_stages'")->fetch();
    if (!$tableExists) {
        die("جدول virtual_stages وجود ندارد. احتمالاً دیتابیس جدید است.\n");
    }
    
    // 2. بررسی schema فعلی
    $schema = $pdo->query("SELECT sql FROM sqlite_master WHERE type='table' AND name='virtual_stages'")->fetchColumn();
    echo "Schema فعلی:\n";
    echo $schema . "\n\n";
    
    // 3. بررسی اینکه آیا 'inactive_without_purchase' در CHECK constraint وجود دارد
    if (strpos($schema, 'inactive_without_purchase') !== false && 
        strpos($schema, 'inactive_with_purchase') !== false &&
        strpos($schema, 'refer_crm') !== false) {
        echo "✅ Schema به‌روز است. نیازی به migration نیست.\n";
        exit(0);
    }
    
    echo "⚠️  Schema قدیمی است. در حال به‌روزرسانی...\n\n";
    
    // 4. Backup داده‌ها
    echo "1. ایجاد backup...\n";
    $pdo->exec("CREATE TABLE IF NOT EXISTS virtual_stages_backup_" . date('YmdHis') . " AS SELECT * FROM virtual_stages");
    $backupCount = $pdo->query("SELECT COUNT(*) FROM virtual_stages")->fetchColumn();
    echo "   ✅ $backupCount رکورد backup شد\n\n";
    
    // 5. ذخیره داده‌های فعلی
    echo "2. ذخیره داده‌های فعلی...\n";
    $currentData = $pdo->query("SELECT * FROM virtual_stages")->fetchAll(PDO::FETCH_ASSOC);
    echo "   ✅ " . count($currentData) . " رکورد ذخیره شد\n\n";
    
    // 6. Drop جدول قدیمی
    echo "3. حذف جدول قدیمی...\n";
    $pdo->exec("DROP TABLE IF EXISTS virtual_stages");
    echo "   ✅ جدول قدیمی حذف شد\n\n";
    
    // 7. ایجاد جدول جدید با schema به‌روز
    echo "4. ایجاد جدول جدید با schema به‌روز...\n";
    $pdo->exec("CREATE TABLE virtual_stages (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        contact_didar_id TEXT NOT NULL,
        stage_name TEXT CHECK(stage_name IN (
            'inactive_failed', 'inactive_success', 'inactive_with_purchase', 'inactive_without_purchase',
            'new', 'contact_no_answer', 'contact_followup', 'deal_registered', 'payment', 
            'payment_followup', 'course_delivered', 'support', 'refer_crm'
        )),
        entered_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        last_activity_id TEXT,
        notes TEXT,
        UNIQUE(contact_didar_id, stage_name)
    )");
    echo "   ✅ جدول جدید ایجاد شد\n\n";
    
    // 8. بازگرداندن داده‌ها (فقط رکوردهایی که stage_name معتبر دارند)
    echo "5. بازگرداندن داده‌ها...\n";
    $validStages = [
        'inactive_failed', 'inactive_success', 'inactive_with_purchase', 'inactive_without_purchase',
        'new', 'contact_no_answer', 'contact_followup', 'deal_registered', 'payment', 
        'payment_followup', 'course_delivered', 'support', 'refer_crm'
    ];
    
    $inserted = 0;
    $skipped = 0;
    $stmt = $pdo->prepare("INSERT INTO virtual_stages (contact_didar_id, stage_name, entered_at, last_activity_id, notes) VALUES (?, ?, ?, ?, ?)");
    
    foreach ($currentData as $row) {
        if (in_array($row['stage_name'], $validStages)) {
            $stmt->execute([
                $row['contact_didar_id'],
                $row['stage_name'],
                $row['entered_at'] ?? date('Y-m-d H:i:s'),
                $row['last_activity_id'] ?? null,
                $row['notes'] ?? null
            ]);
            $inserted++;
        } else {
            $skipped++;
            echo "   ⚠️  رکورد با stage_name نامعتبر رد شد: " . $row['stage_name'] . "\n";
        }
    }
    
    echo "   ✅ $inserted رکورد بازگردانی شد\n";
    if ($skipped > 0) {
        echo "   ⚠️  $skipped رکورد رد شد (stage_name نامعتبر)\n";
    }
    echo "\n";
    
    // 9. بررسی نهایی
    echo "6. بررسی نهایی...\n";
    $finalCount = $pdo->query("SELECT COUNT(*) FROM virtual_stages")->fetchColumn();
    echo "   ✅ تعداد رکوردهای نهایی: $finalCount\n\n";
    
    echo "=== Migration تکمیل شد ===\n";
    echo "توجه: Backup در جدول virtual_stages_backup_" . date('YmdHis') . " ذخیره شده است.\n";
    
} catch (PDOException $e) {
    die("❌ خطا: " . $e->getMessage() . "\n");
}
?>

