# Start PHP Server
$scriptPath = Split-Path -Parent $MyInvocation.MyCommand.Path
$projectRoot = Join-Path $scriptPath "..\.."
Set-Location $projectRoot

Write-Host "Starting PHP Server on http://localhost:8000" -ForegroundColor Green
Write-Host "Press Ctrl+C to stop the server" -ForegroundColor Yellow
Write-Host ""

# Try to find PHP
$phpPath = $null

# Check common PHP locations
$phpLocations = @(
    "C:\xampp\php\php.exe",
    "C:\wamp\bin\php\php.exe",
    "C:\php\php.exe",
    "C:\Program Files\PHP\php.exe"
)

foreach ($location in $phpLocations) {
    if (Test-Path $location) {
        $phpPath = $location
        break
    }
}

# Try WSL if PHP not found in Windows
if (-not $phpPath) {
    Write-Host "PHP not found in Windows. Trying WSL..." -ForegroundColor Yellow
    Write-Host "Please run this command manually in WSL:" -ForegroundColor Cyan
    Write-Host "wsl bash -c 'cd /mnt/c/Users/asus/OneDrive/Documents/GitHub/SaleOs && php -S localhost:8000'" -ForegroundColor White
    Write-Host ""
    Write-Host "Or install PHP for Windows and try again." -ForegroundColor Yellow
    pause
    exit
}

# Start server
& $phpPath -S localhost:8000


