<?php
/**
 * Quick KPI Test to verify the table alias fix
 * Date: 2025-01-04
 */

require_once __DIR__ . '/../../vendor/autoload.php';
require_once __DIR__ . '/../../app/bootstrap.php';

use App\Database\Connection;
use App\Repositories\KpiRepository;
use App\Utils\Logger;

$db = Connection::getInstance();
$kpiRepo = new KpiRepository($db);

echo "Testing KPI functionality after table alias fix...\n\n";

$filters = [
    'date_from' => '2025-01-01',
    'date_to' => '2025-01-31',
    'owner_didar_id' => 'test_agent_1'  // This will filter to our test data if it exists
];

$tests = [
    'getSales' => 'Sales KPI',
    'getSettledDeals' => 'Settled Deals KPI',
    'getOutstandingBalance' => 'Outstanding Balance KPI',
    'getTimeToConversion' => 'Time to Conversion KPI',
    'getLostSales' => 'Lost Sales KPI',
    'getOpenPipeline' => 'Open Pipeline KPI',
    'getNewLeadConversionRate' => 'Lead Conversion Rate KPI'
];

$passed = 0;
$failed = 0;

foreach ($tests as $method => $name) {
    try {
        echo "Testing {$name}... ";
        $result = $kpiRepo->$method($filters);

        if (is_array($result)) {
            echo "✅ PASS\n";
            $passed++;
        } else {
            echo "❌ FAIL (not array)\n";
            $failed++;
        }
    } catch (Exception $e) {
        echo "❌ FAIL: " . $e->getMessage() . "\n";
        $failed++;
    }
}

echo "\n" . str_repeat("=", 50) . "\n";
echo "Test Results:\n";
echo "Passed: {$passed}\n";
echo "Failed: {$failed}\n";
echo "Total: " . ($passed + $failed) . "\n";

if ($failed === 0) {
    echo "\n🎉 All KPI methods work without table alias errors!\n";
} else {
    echo "\n⚠️ Some tests failed. Check the error messages above.\n";
}

echo "\nIf you see 'Unknown column' errors, the database migrations may not be applied.\n";
echo "Run the migrations from phpMyAdmin as instructed in the previous message.\n";

