#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
بررسی نحوه ذخیره تاریخ‌ها در دیتابیس فعلی
"""

import sqlite3
import sys

if sys.platform == 'win32':
    import io
    sys.stdout = io.TextIOWrapper(sys.stdout.buffer, encoding='utf-8')

DB_PATH = "crm_database_new.db"

conn = sqlite3.connect(DB_PATH)
cursor = conn.cursor()

print("=" * 60)
print("بررسی نحوه ذخیره تاریخ‌ها در دیتابیس")
print("=" * 60)

# بررسی جدول activities
print("\n📋 جدول activities:")
cursor.execute("SELECT didar_activity_id, title, due_date, done_date, register_date FROM activities LIMIT 5")
activities = cursor.fetchall()
print(f"تعداد فعالیت‌ها: {len(activities)}")
for act in activities:
    print(f"  Activity ID: {act[0]}")
    print(f"    Title: {act[1]}")
    print(f"    Due Date: {act[2]} (type: {type(act[2])})")
    print(f"    Done Date: {act[3]} (type: {type(act[3])})")
    print(f"    Register Date: {act[4]} (type: {type(act[4])})")
    print()

# بررسی جدول persons
print("\n📋 جدول persons:")
cursor.execute("SELECT didar_contact_id, last_name, register_time, last_sync FROM persons LIMIT 3")
persons = cursor.fetchall()
for p in persons:
    print(f"  Contact ID: {p[0]}")
    print(f"    Name: {p[1]}")
    print(f"    Register Time: {p[2]} (type: {type(p[2])})")
    print(f"    Last Sync: {p[3]} (type: {type(p[3])})")
    print()

# بررسی جدول deals
print("\n📋 جدول deals:")
cursor.execute("SELECT didar_deal_id, title, register_time, won_time FROM deals LIMIT 3")
deals = cursor.fetchall()
for d in deals:
    print(f"  Deal ID: {d[0]}")
    print(f"    Title: {d[1]}")
    print(f"    Register Time: {d[2]} (type: {type(d[2])})")
    print(f"    Won Time: {d[3]} (type: {type(d[3])})")
    print()

conn.close()




