#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""بررسی عدم تطابق didar_user_id با owner_didar_id"""

import sqlite3
import os

DB_FILE = 'crm_database.db'

if not os.path.exists(DB_FILE):
    print(f"❌ فایل دیتابیس یافت نشد: {DB_FILE}")
    exit(1)

conn = sqlite3.connect(DB_FILE)
cursor = conn.cursor()

print("=" * 70)
print("بررسی عدم تطابق didar_user_id با owner_didar_id")
print("=" * 70)

# 1. بررسی کاربر ظهوری
print("\n1. بررسی کاربر ظهوری:")
print("-" * 70)
user = cursor.execute("""
    SELECT id, didar_user_id, display_name, role 
    FROM users 
    WHERE display_name LIKE '%ظهوری%'
""").fetchone()

if user:
    user_id, didar_user_id, display_name, role = user
    print(f"   ID: {user_id}")
    print(f"   didar_user_id: {didar_user_id}")
    print(f"   display_name: {display_name}")
    print(f"   role: {role}")
else:
    print("   ❌ کاربر ظهوری پیدا نشد!")
    conn.close()
    exit(1)

# 2. بررسی owner_didar_id لیدها
print("\n2. بررسی owner_didar_id لیدها:")
print("-" * 70)
owner_ids = cursor.execute("""
    SELECT DISTINCT owner_didar_id, COUNT(*) as cnt 
    FROM persons 
    WHERE owner_didar_id IS NOT NULL
    GROUP BY owner_didar_id
    ORDER BY cnt DESC
""").fetchall()

print("   owner_didar_id های موجود در لیدها:")
for owner_id, count in owner_ids:
    match = "✅" if owner_id == didar_user_id else "❌"
    print(f"   {match} {owner_id}: {count} لید")

# 3. بررسی تطابق
print("\n3. بررسی تطابق:")
print("-" * 70)
if owner_ids:
    most_common_owner = owner_ids[0][0]
    print(f"   didar_user_id کاربر: {didar_user_id}")
    print(f"   owner_didar_id لیدها: {most_common_owner}")
    
    if didar_user_id == most_common_owner:
        print("\n   ✅ تطابق کامل!")
    else:
        print("\n   ❌ عدم تطابق!")
        print(f"   باید didar_user_id را به {most_common_owner} تغییر دهیم")
        
        # 4. تعداد لیدهای کاربر با didar_user_id فعلی
        count_current = cursor.execute("""
            SELECT COUNT(*) 
            FROM persons 
            WHERE owner_didar_id = ?
        """, (didar_user_id,)).fetchone()[0]
        
        # 5. تعداد لیدهای کاربر با owner_didar_id لیدها
        count_correct = cursor.execute("""
            SELECT COUNT(*) 
            FROM persons 
            WHERE owner_didar_id = ?
        """, (most_common_owner,)).fetchone()[0]
        
        print(f"\n   لیدهای با didar_user_id فعلی ({didar_user_id}): {count_current}")
        print(f"   لیدهای با owner_didar_id صحیح ({most_common_owner}): {count_correct}")
        
        # 6. پیشنهاد اصلاح
        print("\n4. پیشنهاد اصلاح:")
        print("-" * 70)
        print(f"   UPDATE users SET didar_user_id = '{most_common_owner}' WHERE id = {user_id}")
        print(f"\n   آیا می‌خواهید این تغییر را اعمال کنید؟ (y/n): ", end="")
        
        response = input().strip().lower()
        if response == 'y':
            cursor.execute("""
                UPDATE users 
                SET didar_user_id = ? 
                WHERE id = ?
            """, (most_common_owner, user_id))
            conn.commit()
            print("\n   ✅ تغییر اعمال شد!")
            
            # بررسی مجدد
            user_after = cursor.execute("""
                SELECT didar_user_id 
                FROM users 
                WHERE id = ?
            """, (user_id,)).fetchone()
            
            print(f"   didar_user_id جدید: {user_after[0]}")
            
            # بررسی تعداد لیدها
            count_after = cursor.execute("""
                SELECT COUNT(*) 
                FROM persons 
                WHERE owner_didar_id = ?
            """, (most_common_owner,)).fetchone()[0]
            
            print(f"   تعداد لیدهای قابل مشاهده: {count_after}")
        else:
            print("\n   تغییر اعمال نشد.")
else:
    print("   ❌ هیچ لیدی با owner_didar_id پیدا نشد!")

conn.close()
print("\n" + "=" * 70)

