#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""بررسی دیتابیس‌ها"""

import sqlite3
import os

files = ['crm_database.db', 'crm_database_zahoori.db']

for f in files:
    if os.path.exists(f):
        print(f"\n=== {f} ===")
        conn = sqlite3.connect(f)
        user = conn.execute("SELECT id, didar_user_id, display_name FROM users WHERE display_name LIKE '%ظهوری%'").fetchone()
        if user:
            print(f"کاربر ظهوری:")
            print(f"  ID: {user[0]}")
            print(f"  didar_user_id: {user[1]}")
            print(f"  display_name: {user[2]}")
        else:
            print("کاربر ظهوری پیدا نشد")
        
        leads = conn.execute('SELECT COUNT(*) FROM persons').fetchone()[0]
        print(f"تعداد لیدها: {leads}")
        
        if user and leads > 0:
            count = conn.execute('SELECT COUNT(*) FROM persons WHERE owner_didar_id = ?', (user[1],)).fetchone()[0]
            print(f"لیدهای کاربر ظهوری: {count}")
        
        conn.close()
    else:
        print(f"\n=== {f} ===")
        print("فایل وجود ندارد")

