#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
بررسی mapping بین مسئول مشتری در اکسل و کاربران در دیتابیس
"""

import sqlite3
import pandas as pd
import sys

# تنظیم encoding برای Windows
if sys.platform == 'win32':
    import io
    sys.stdout = io.TextIOWrapper(sys.stdout.buffer, encoding='utf-8')
    sys.stderr = io.TextIOWrapper(sys.stderr.buffer, encoding='utf-8')

DB_PATH = "crm_database (5).db"
EXCEL_PATH = "پایگاه داده با فروش قبلی.xlsx"

# خواندن کاربران از دیتابیس
conn = sqlite3.connect(DB_PATH)
cursor = conn.cursor()
cursor.execute("SELECT id, display_name, didar_user_id FROM users WHERE is_active = 1")
users = {row[1]: row[2] for row in cursor.fetchall()}
print(f"کاربران فعال در دیتابیس ({len(users)}):")
for name, didar_id in sorted(users.items()):
    print(f"  {name}: {didar_id}")
conn.close()

# خواندن اکسل
df = pd.read_excel(EXCEL_PATH)
print(f"\nتعداد ردیف‌ها در اکسل: {len(df)}")

# بررسی ستون مسئول مشتری
owner_col = "مسئول مشتری"
if owner_col in df.columns:
    unique_owners = df[owner_col].dropna().unique()
    print(f"\nمسئولان منحصر به فرد در اکسل ({len(unique_owners)}):")
    for owner in sorted(unique_owners):
        count = len(df[df[owner_col] == owner])
        match = "✅" if owner in users else "❌"
        print(f"  {match} {owner}: {count} لید")
    
    # بررسی mapping
    print("\n" + "=" * 60)
    print("بررسی mapping:")
    print("=" * 60)
    
    matched = []
    unmatched = []
    
    for owner in unique_owners:
        if owner in users:
            matched.append(owner)
        else:
            unmatched.append(owner)
    
    print(f"\n✅ تطبیق یافته ({len(matched)}):")
    for owner in sorted(matched):
        print(f"  {owner} -> {users[owner]}")
    
    print(f"\n❌ تطبیق نیافته ({len(unmatched)}):")
    for owner in sorted(unmatched):
        count = len(df[df[owner_col] == owner])
        print(f"  {owner} ({count} لید)")
        
        # جستجوی مشابه
        for db_user in users.keys():
            if owner.strip() in db_user or db_user.strip() in owner:
                print(f"    💡 احتمالاً: {db_user}")
else:
    print(f"\n❌ ستون '{owner_col}' پیدا نشد!")

