#!/usr/bin/env python3
# -*- coding: utf-8 -*-
import sqlite3
import sys

if sys.platform == 'win32':
    import io
    sys.stdout = io.TextIOWrapper(sys.stdout.buffer, encoding='utf-8')

conn = sqlite3.connect('crm_database_new.db')
cursor = conn.cursor()

cursor.execute('PRAGMA table_info(persons)')
cols = [row[1] for row in cursor.fetchall()]
print('Columns:', cols)
print('customer_products exists:', 'customer_products' in cols)

cursor.execute('SELECT didar_contact_id, last_name, mobile_phone, city, job_title, customer_products, has_previous_purchase FROM persons LIMIT 5')
print('\nSample data:')
for row in cursor.fetchall():
    print(row)

# بررسی virtual stages
cursor.execute('SELECT stage_name, COUNT(*) FROM virtual_stages GROUP BY stage_name')
print('\nVirtual stages distribution:')
for row in cursor.fetchall():
    print(f'  {row[0]}: {row[1]}')

conn.close()

