#!/usr/bin/env python3
# -*- coding: utf-8 -*-
import pandas as pd
import sys
import re

if sys.platform == 'win32':
    import io
    sys.stdout = io.TextIOWrapper(sys.stdout.buffer, encoding='utf-8')

df = pd.read_excel('پایگاه داده با فروش قبلی.xlsx')

# پیدا کردن ردیف با didar_contact_id = 15659
row = df[df['کد دیدار شخص'] == 15659]
if not row.empty:
    phone = row.iloc[0]['تلفن همراه مشتری']
    print(f"Phone for contact 15659: {phone}")
    print(f"Type: {type(phone)}")
    print(f"String: '{str(phone)}'")
    
    # تست remove_leading_zero
    def remove_leading_zero(phone):
        if not phone:
            return None
        phone = str(phone).strip()
        phone = re.sub(r'[^\d]', '', phone)
        if phone.startswith('0'):
            phone = phone[1:]
        return phone if phone else None
    
    result = remove_leading_zero(phone)
    print(f"After remove_leading_zero: '{result}'")

