#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""بررسی تطابق کاربر ظهوری با لیدها"""

import sqlite3

DB_FILE = 'crm_database_zahoori.db'

conn = sqlite3.connect(DB_FILE)
cursor = conn.cursor()

print("=" * 60)
print("گزارش بررسی کاربر ظهوری")
print("=" * 60)

# 1. بررسی کاربر ظهوری در جدول users
print("\n1. بررسی کاربر ظهوری در جدول users:")
print("-" * 60)

cursor.execute("""
    SELECT id, didar_user_id, display_name, email, role 
    FROM users 
    WHERE display_name LIKE '%ظهوری%' 
       OR didar_user_id = '55f5c374-4cf0-4e3e-8386-96ac21e7ac79' 
       OR didar_user_id = '6d5350f0-5ee7-47d3-9eef-094698f6d070'
""")

user = cursor.fetchone()
if user:
    print("✅ کاربر پیدا شد:")
    print(f"   ID: {user[0]}")
    print(f"   didar_user_id: {user[1]}")
    print(f"   display_name: {user[2]}")
    print(f"   email: {user[3]}")
    print(f"   role: {user[4]}")
else:
    print("❌ کاربر ظهوری پیدا نشد!")

# 2. بررسی owner_didar_id لیدها
print("\n2. بررسی owner_didar_id لیدها:")
print("-" * 60)

cursor.execute("""
    SELECT DISTINCT owner_didar_id, COUNT(*) as cnt 
    FROM persons 
    GROUP BY owner_didar_id
""")

leads = cursor.fetchall()
print("Owner IDs در لیدها:")
for lead in leads:
    print(f"   {lead[0]}: {lead[1]} لید")

# 3. بررسی didar_user_id همه کاربران
print("\n3. بررسی didar_user_id همه کاربران:")
print("-" * 60)

cursor.execute("""
    SELECT didar_user_id, display_name, role 
    FROM users 
    ORDER BY display_name
""")

users = cursor.fetchall()
print("didar_user_id کاربران:")
for u in users:
    print(f"   {u[0]}: {u[1]} ({u[2]})")

# 4. مقایسه و تحلیل
print("\n4. مقایسه و تحلیل:")
print("-" * 60)

print("\nاطلاعات از فایل didar_users_output.txt:")
print("   Owner ID: 55f5c374-4cf0-4e3e-8386-96ac21e7ac79")
print("   User ID: 6d5350f0-5ee7-47d3-9eef-094698f6d070")

if user:
    user_didar_id = user[1]
    owner_id_in_leads = leads[0][0] if leads else None
    
    print(f"\n✅ didar_user_id کاربر ظهوری: {user_didar_id}")
    print(f"✅ owner_didar_id لیدها: {owner_id_in_leads}")
    
    if user_didar_id == owner_id_in_leads:
        print("\n✅ تطابق کامل! مشکل در جای دیگری است.")
    else:
        print(f"\n❌ عدم تطابق!")
        print(f"   didar_user_id کاربر ≠ owner_didar_id لیدها")
        print(f"   تفاوت: {user_didar_id} ≠ {owner_id_in_leads}")
        print("\n💡 راه حل:")
        print("   باید didar_user_id کاربر ظهوری را به '55f5c374-4cf0-4e3e-8386-96ac21e7ac79' تغییر دهید")
else:
    print("\n❌ کاربر ظهوری در جدول users وجود ندارد!")
    print("\n💡 راه حل:")
    print("   باید کاربر ظهوری را با didar_user_id = '55f5c374-4cf0-4e3e-8386-96ac21e7ac79' اضافه کنید")

# 5. بررسی تعداد لیدها برای هر owner
print("\n5. بررسی تعداد لیدها:")
print("-" * 60)

cursor.execute("SELECT COUNT(*) FROM persons")
total_leads = cursor.fetchone()[0]
print(f"کل لیدها: {total_leads}")

if user:
    cursor.execute("""
        SELECT COUNT(*) 
        FROM persons 
        WHERE owner_didar_id = ?
    """, (user[1],))
    leads_for_user = cursor.fetchone()[0]
    print(f"لیدهای با owner_didar_id = {user[1]}: {leads_for_user}")
    
    cursor.execute("""
        SELECT COUNT(*) 
        FROM persons 
        WHERE owner_didar_id = '55f5c374-4cf0-4e3e-8386-96ac21e7ac79'
    """)
    leads_with_correct_owner = cursor.fetchone()[0]
    print(f"لیدهای با owner_didar_id = 55f5c374-4cf0-4e3e-8386-96ac21e7ac79: {leads_with_correct_owner}")

conn.close()

print("\n" + "=" * 60)
print("گزارش کامل شد")
print("=" * 60)

