<?php
/**
 * Extract JavaScript from index.php
 */

$indexFile = __DIR__ . '/../../index.php';
$outputFile = __DIR__ . '/../../assets/js/app.js';

$content = file_get_contents($indexFile);

// Find JavaScript section (between <script> and </script>)
$startPos = strpos($content, '<script>');
$endPos = strrpos($content, '</script>');

if ($startPos === false || $endPos === false) {
    die("Could not find JavaScript section\n");
}

// Extract JavaScript (skip <script> tag)
$startPos = strpos($content, "\n", $startPos) + 1;
$endPos = strrpos($content, "\n", $endPos - strlen($content));

$javascript = substr($content, $startPos, $endPos - $startPos);

// Write to output file
file_put_contents($outputFile, $javascript);

echo "JavaScript extracted to: $outputFile\n";
echo "Size: " . strlen($javascript) . " bytes\n";

