#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""اصلاح didar_user_id کاربر ظهوری"""

import sqlite3

DB_FILE = 'crm_database_zahoori.db'

conn = sqlite3.connect(DB_FILE)
cursor = conn.cursor()

print("=" * 60)
print("اعمال تغییر didar_user_id کاربر ظهوری")
print("=" * 60)

# بررسی قبل از تغییر
print("\n1. وضعیت قبل از تغییر:")
print("-" * 60)
user_before = cursor.execute("""
    SELECT didar_user_id, display_name 
    FROM users 
    WHERE display_name LIKE '%ظهوری%'
""").fetchone()

if user_before:
    print(f"   didar_user_id: {user_before[0]}")
    print(f"   display_name: {user_before[1]}")

# اعمال تغییر
print("\n2. اعمال تغییر:")
print("-" * 60)
cursor.execute("""
    UPDATE users 
    SET didar_user_id = '55f5c374-4cf0-4e3e-8386-96ac21e7ac79' 
    WHERE display_name LIKE '%ظهوری%'
""")
conn.commit()

print(f"✅ {cursor.rowcount} کاربر به‌روزرسانی شد")

# بررسی بعد از تغییر
print("\n3. وضعیت بعد از تغییر:")
print("-" * 60)
user_after = cursor.execute("""
    SELECT didar_user_id, display_name 
    FROM users 
    WHERE display_name LIKE '%ظهوری%'
""").fetchone()

if user_after:
    print(f"   didar_user_id: {user_after[0]}")
    print(f"   display_name: {user_after[1]}")

# بررسی تطابق
print("\n4. بررسی تطابق:")
print("-" * 60)
leads_count = cursor.execute("""
    SELECT COUNT(*) 
    FROM persons 
    WHERE owner_didar_id = '55f5c374-4cf0-4e3e-8386-96ac21e7ac79'
""").fetchone()[0]

print(f"تعداد لیدها با owner_didar_id = 55f5c374-4cf0-4e3e-8386-96ac21e7ac79: {leads_count}")

if user_after and user_after[0] == '55f5c374-4cf0-4e3e-8386-96ac21e7ac79':
    print("\n✅ تطابق کامل!")
    print("✅ حالا کاربر ظهوری می‌تواند {leads_count} لید را ببیند.")
else:
    print("\n❌ هنوز تطابق ندارد!")

conn.close()

print("\n" + "=" * 60)
print("تغییر اعمال شد")
print("=" * 60)

