<?php
/**
 * اسکریپت دریافت لیست کاربران دیدار با استفاده از API
 * خروجی: نام کاربر و Owner ID
 */

$apiKey = 'o2wi5oksfn0ha4zppr0xz5637f92mzee';
$apiUrl = 'https://app.didar.me/api/User/List?apikey=' . $apiKey;

// تنظیمات CURL
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Accept: application/json'
]);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([]));
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

// اجرای درخواست
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curlError = curl_error($ch);
curl_close($ch);

// بررسی خطا
if ($curlError) {
    die("خطا در اتصال: " . $curlError . "\n");
}

if ($httpCode !== 200) {
    die("خطا در دریافت داده. کد HTTP: " . $httpCode . "\nپاسخ: " . $response . "\n");
}

// تبدیل JSON به آرایه
$data = json_decode($response, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    die("خطا در تبدیل JSON: " . json_last_error_msg() . "\nپاسخ: " . $response . "\n");
}

// بررسی وجود Response
if (!isset($data['Response']) || !is_array($data['Response'])) {
    die("فرمت پاسخ نامعتبر است.\nپاسخ: " . $response . "\n");
}

$users = $data['Response'];

// نمایش نتایج
echo "========================================\n";
echo "لیست کاربران دیدار\n";
echo "========================================\n";
echo sprintf("%-40s | %-40s | %s\n", "نام کاربر", "Owner ID", "User ID");
echo str_repeat("-", 120) . "\n";

foreach ($users as $user) {
    $displayName = isset($user['DisplayName']) ? $user['DisplayName'] : 
                   (isset($user['FirstName']) && isset($user['LastName']) ? 
                    $user['FirstName'] . ' ' . $user['LastName'] : 'نامشخص');
    
    $ownerId = isset($user['Id']) ? $user['Id'] : 'نامشخص';
    $userId = isset($user['UserId']) ? $user['UserId'] : 'نامشخص';
    
    echo sprintf("%-40s | %-40s | %s\n", 
        mb_substr($displayName, 0, 40, 'UTF-8'),
        mb_substr($ownerId, 0, 40, 'UTF-8'),
        mb_substr($userId, 0, 40, 'UTF-8')
    );
}

echo "\n========================================\n";
echo "تعداد کل کاربران: " . count($users) . "\n";
echo "========================================\n";

// ذخیره در فایل JSON
$outputFile = 'didar_users_output.json';
file_put_contents($outputFile, json_encode($users, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
echo "\nنتایج در فایل JSON ذخیره شد: " . $outputFile . "\n";

// ذخیره در فایل متنی
$outputTextFile = 'didar_users_output.txt';
$textContent = "لیست کاربران دیدار\n";
$textContent .= "========================================\n\n";

foreach ($users as $index => $user) {
    $displayName = isset($user['DisplayName']) ? $user['DisplayName'] : 
                   (isset($user['FirstName']) && isset($user['LastName']) ? 
                    $user['FirstName'] . ' ' . $user['LastName'] : 'نامشخص');
    
    $ownerId = isset($user['Id']) ? $user['Id'] : 'نامشخص';
    $userId = isset($user['UserId']) ? $user['UserId'] : 'نامشخص';
    $userName = isset($user['UserName']) ? $user['UserName'] : 'نامشخص';
    $isOwner = isset($user['IsOwner']) ? ($user['IsOwner'] ? 'بله' : 'خیر') : 'نامشخص';
    
    $textContent .= ($index + 1) . ". نام کاربر: " . $displayName . "\n";
    $textContent .= "   Owner ID: " . $ownerId . "\n";
    $textContent .= "   User ID: " . $userId . "\n";
    $textContent .= "   نام کاربری: " . $userName . "\n";
    $textContent .= "   مسئول: " . $isOwner . "\n";
    $textContent .= "\n";
}

file_put_contents($outputTextFile, $textContent);
echo "نتایج در فایل متنی ذخیره شد: " . $outputTextFile . "\n";

