<?php
$apiKey = 'o2wi5oksfn0ha4zppr0xz5637f92mzee';
$phone = '9111110065';

// Test 1: Search by phone
echo "=== Test 1: Search by phone ===\n";
$searchData = [
    'Criteria' => [
        'ContactType' => 0,
        'IsDeleted' => 0,
        'IsPinned' => -1,
        'IsVIP' => -1,
        'LeadType' => -1,
        'Pin' => -1,
        'SortOrder' => 1,
        'Keywords' => $phone,
        'SearchFromTime' => '1930-01-01T00:00:00.000Z',
        'SearchToTime' => '9999-12-01T00:00:00.000Z',
        'CustomFields' => [],
        'FilterId' => null
    ],
    'From' => 0,
    'Limit' => 10
];

$ch = curl_init("https://app.didar.me/api/contact/PersonSearch?apikey=" . urlencode($apiKey));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($searchData, JSON_UNESCAPED_UNICODE));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Code: $httpCode\n";
$result = json_decode($response, true);
echo "Response:\n";
print_r($result);

if (isset($result['Response']['List']) && count($result['Response']['List']) > 0) {
    $person = $result['Response']['List'][0];
    $contactId = $person['Id'] ?? null;
    
    echo "\n=== Found Person ===\n";
    echo "Id: " . ($person['Id'] ?? 'N/A') . "\n";
    echo "DisplayName: " . ($person['DisplayName'] ?? 'N/A') . "\n";
    echo "MobilePhone: " . ($person['MobilePhone'] ?? 'N/A') . "\n";
    
    if ($contactId) {
        // Test 2: Get deals with ContactIds (array)
        echo "\n=== Test 2: Get deals with ContactIds array ===\n";
        $dealsData = [
            'Criteria' => [
                'ContactIds' => [$contactId],
                'Status' => -1
            ],
            'From' => 0,
            'Limit' => 10
        ];
        
        $ch2 = curl_init("https://app.didar.me/api/deal/search?apikey=" . urlencode($apiKey));
        curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch2, CURLOPT_POST, true);
        curl_setopt($ch2, CURLOPT_POSTFIELDS, json_encode($dealsData, JSON_UNESCAPED_UNICODE));
        curl_setopt($ch2, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        curl_setopt($ch2, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch2, CURLOPT_SSL_VERIFYHOST, false);
        
        $dealsResponse = curl_exec($ch2);
        $dealsHttpCode = curl_getinfo($ch2, CURLINFO_HTTP_CODE);
        curl_close($ch2);
        
        echo "HTTP Code: $dealsHttpCode\n";
        $dealsResult = json_decode($dealsResponse, true);
        echo "Deals Response:\n";
        print_r($dealsResult);
        
        // Test 3: Get activities with ContactId
        echo "\n=== Test 3: Get activities with ContactId ===\n";
        $activitiesData = [
            'ContactId' => $contactId,
            'FromDate' => '1901-01-01T00:00:00.000Z',
            'ToDate' => '9999-12-01T00:00:00.000Z',
            'IsDone' => -1,
            'From' => 0,
            'Limit' => 10
        ];
        
        $ch3 = curl_init("https://app.didar.me/api/activity/search?apikey=" . urlencode($apiKey));
        curl_setopt($ch3, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch3, CURLOPT_POST, true);
        curl_setopt($ch3, CURLOPT_POSTFIELDS, json_encode($activitiesData, JSON_UNESCAPED_UNICODE));
        curl_setopt($ch3, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        curl_setopt($ch3, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch3, CURLOPT_SSL_VERIFYHOST, false);
        
        $activitiesResponse = curl_exec($ch3);
        $activitiesHttpCode = curl_getinfo($ch3, CURLINFO_HTTP_CODE);
        curl_close($ch3);
        
        echo "HTTP Code: $activitiesHttpCode\n";
        $activitiesResult = json_decode($activitiesResponse, true);
        echo "Activities Response:\n";
        print_r($activitiesResult);
        
        // Test 4: Try with numeric contactId (15926)
        echo "\n=== Test 4: Try deals with numeric contactId (15926) ===\n";
        $dealsDataNumeric = [
            'Criteria' => [
                'ContactIds' => ['15926'],
                'Status' => -1
            ],
            'From' => 0,
            'Limit' => 10
        ];
        
        $ch4 = curl_init("https://app.didar.me/api/deal/search?apikey=" . urlencode($apiKey));
        curl_setopt($ch4, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch4, CURLOPT_POST, true);
        curl_setopt($ch4, CURLOPT_POSTFIELDS, json_encode($dealsDataNumeric, JSON_UNESCAPED_UNICODE));
        curl_setopt($ch4, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        curl_setopt($ch4, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch4, CURLOPT_SSL_VERIFYHOST, false);
        
        $dealsResponseNumeric = curl_exec($ch4);
        $dealsHttpCodeNumeric = curl_getinfo($ch4, CURLINFO_HTTP_CODE);
        curl_close($ch4);
        
        echo "HTTP Code: $dealsHttpCodeNumeric\n";
        $dealsResultNumeric = json_decode($dealsResponseNumeric, true);
        echo "Deals Response (numeric):\n";
        print_r($dealsResultNumeric);
    }
}
?>

