#!/usr/bin/env python3
# -*- coding: utf-8 -*-
import re

def remove_leading_zero(phone):
    """حذف صفر اول از شماره تلفن"""
    if not phone:
        return None
    
    phone = str(phone).strip()
    # حذف فاصله‌ها و کاراکترهای غیر عددی
    phone = re.sub(r'[^\d]', '', phone)
    
    # اگر با 0 شروع می‌شود، آن را حذف کن
    if phone.startswith('0'):
        phone = phone[1:]
    
    return phone if phone else None

# تست
test_numbers = ['019029996151', '09123456789', '00989123456789', '17672539332']
for num in test_numbers:
    result = remove_leading_zero(num)
    print(f"{num} -> {result}")

