<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>آکادمی حنفی‌کار | پنل فروش</title>
    <link rel="icon" type="image/png" href="/logo.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!-- jQuery must be loaded before persian-datepicker -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Persian Date Picker -->
    <link rel="stylesheet" href="https://unpkg.com/persian-datepicker@1.2.0/dist/css/persian-datepicker.min.css">
    <script src="https://unpkg.com/persian-date@1.1.0/dist/persian-date.min.js"></script>
    <script src="https://unpkg.com/persian-datepicker@1.2.0/dist/js/persian-datepicker.min.js"></script>
    <!-- Moment.js (Jalali handled by persian-date fallback in app.js if needed) -->
    <script src="https://cdn.jsdelivr.net/npm/moment@2.29.4/moment.min.js"></script>
    <link rel="stylesheet" href="/assets/css/main.css?v=<?php echo time(); ?>">
</head>
<body class="h-screen overflow-hidden">

<?php echo $content ?? ''; ?>

<script>
    // Define APP_USER and CURRENT_USER_ID before loading app.js
    window.APP_USER = <?php echo json_encode([
        'role' => $_SESSION['role'] ?? 'guest',
        'didar_id' => $_SESSION['didar_id'] ?? null,
        'name' => $_SESSION['name'] ?? ''
    ], JSON_UNESCAPED_UNICODE); ?>;
    window.CURRENT_USER_ID = <?php echo $_SESSION['user_id'] ?? 0; ?>;
</script>
	<script src="/assets/js/logger.js?v=<?php echo time(); ?>"></script>
	<?php $appJsVersion = @filemtime(__DIR__ . '/../../assets/js/app.js') ?: time(); ?>
	<script src="/assets/js/app.js?v=<?php echo $appJsVersion; ?>"></script>
<script>
    // Initialize on page load
    document.addEventListener('DOMContentLoaded', () => {
        <?php if(isset($_SESSION['user_id'])): ?>
            // Set user display
            const userDisplay = document.getElementById('user-display');
            if(userDisplay) {
                const role = '<?php echo $_SESSION['role'] ?? ''; ?>';
                const roleText = role === 'admin' ? ' (مدیر)' : (role === 'crm_specialist' ? ' (کارشناس CRM)' : '');
                userDisplay.textContent = '<?php echo addslashes($_SESSION['name'] ?? ''); ?>' + roleText;
            }
            <?php if(($_SESSION['role'] ?? '') === 'admin'): ?>
                const adminSection = document.getElementById('admin-section');
                if(adminSection) adminSection.classList.remove('hidden');
            <?php endif; ?>
            if (typeof app !== 'undefined') {
                app.init();
                // Update sound button after init
                setTimeout(() => {
                    if (app.updateSoundButton) {
                        app.updateSoundButton();
                    }
                }, 100);
            }
        <?php endif; ?>
    });
</script>
</body>
</html>

