<!-- MODALS -->

<!-- New User Modal -->
<div id="modalUser" class="fixed inset-0 bg-black/80 hidden z-50 flex items-center justify-center p-4 backdrop-blur-sm">
    <div class="glass w-full max-w-md p-6">
        <div class="flex justify-between items-center mb-4">
            <h3 class="font-bold text-white text-lg">تعریف کاربر جدید</h3>
            <button onclick="app.closeModal('modalUser')" class="text-gray-500 hover:text-white"><i class="fa-solid fa-times"></i></button>
        </div>
        <form onsubmit="app.saveUser(event)" class="space-y-3">
            <input type="hidden" name="user_id" id="user-form-id" value="">
            <select name="didar_user_id" required class="input bg-gray-800" id="user-didar-select">
                <option value="">-- انتخاب کاربر از دیدار --</option>
            </select>
            <input type="email" name="email" placeholder="ایمیل" required class="input">
            <input type="text" name="first_name" placeholder="نام" required class="input">
            <input type="text" name="last_name" placeholder="نام خانوادگی" required class="input">
            <select name="role" required class="input bg-gray-800">
                <option value="agent">کارشناس</option>
                <option value="crm_specialist">کارشناس CRM</option>
                <option value="admin">مدیر</option>
            </select>
            <button type="submit" class="btn-primary w-full py-2 rounded-lg mt-4">ذخیره</button>
        </form>
    </div>
</div>

<!-- Edit User Role Modal -->
<div id="modalEditUserRole" class="fixed inset-0 bg-black/80 hidden z-50 flex items-center justify-center p-4 backdrop-blur-sm">
    <div class="glass w-full max-w-md p-6">
        <div class="flex justify-between items-center mb-4">
            <h3 class="font-bold text-white text-lg">ویرایش نقش کاربر</h3>
            <button onclick="app.closeModal('modalEditUserRole')" class="text-gray-500 hover:text-white"><i class="fa-solid fa-times"></i></button>
        </div>
        <form onsubmit="app.saveUserRole(event)" class="space-y-4">
            <input type="hidden" name="user_id" id="edit-role-user-id" value="">
            <div>
                <label class="text-sm text-gray-400 mb-2 block">نام کاربر</label>
                <div class="text-white font-bold" id="edit-role-user-name">-</div>
            </div>
            <div>
                <label class="text-sm text-gray-400 mb-2 block">نقش <span class="text-red-500">*</span></label>
                <select name="role" id="edit-role-select" required class="input bg-gray-800">
                    <option value="agent">کارشناس</option>
                    <option value="crm_specialist">کارشناس CRM</option>
                    <option value="admin">مدیر</option>
                </select>
            </div>
            <button type="submit" class="btn-primary w-full py-2 rounded-lg">ذخیره تغییرات</button>
        </form>
    </div>
</div>

<!-- Change Password Modal -->
<div id="modalChangePassword" class="fixed inset-0 bg-black/80 hidden z-50 flex items-center justify-center p-4 backdrop-blur-sm">
    <div class="glass w-full max-w-md p-6">
        <div class="flex justify-between items-center mb-4">
            <h3 class="font-bold text-white text-lg">تغییر رمز عبور</h3>
            <button onclick="app.closeModal('modalChangePassword')" class="text-gray-500 hover:text-white"><i class="fa-solid fa-times"></i></button>
        </div>
        <form onsubmit="app.changePassword(event)" class="space-y-3">
            <input type="hidden" name="user_id" id="change-password-user-id" value="">
            <div id="change-password-current-section">
                <label class="text-sm text-gray-400 mb-1 block">رمز عبور فعلی</label>
                <input type="password" name="current_password" id="change-password-current" placeholder="رمز عبور فعلی" class="input" required>
            </div>
            <div>
                <label class="text-sm text-gray-400 mb-1 block">رمز عبور جدید</label>
                <input type="password" name="new_password" id="change-password-new" placeholder="رمز عبور جدید (حداقل 6 کاراکتر)" class="input" required minlength="6">
            </div>
            <div>
                <label class="text-sm text-gray-400 mb-1 block">تأیید رمز عبور جدید</label>
                <input type="password" name="confirm_password" id="change-password-confirm" placeholder="تأیید رمز عبور جدید" class="input" required minlength="6">
            </div>
            <button type="submit" class="btn-primary w-full py-2 rounded-lg mt-4">تغییر رمز عبور</button>
        </form>
    </div>
</div>

<!-- Profile History Modal -->
<div id="modalProfile" class="fixed inset-0 bg-black/95 hidden z-50 flex items-center justify-center p-4 backdrop-blur-md">
    <div class="glass w-full max-w-5xl xl:max-w-7xl h-[90vh] flex flex-col overflow-hidden border-2 border-gray-800">
        <!-- Header -->
        <div class="p-5 border-b border-gray-700 bg-gray-800/50 flex flex-col md:flex-row justify-between items-start md:items-center gap-4">
            <div class="flex items-center gap-4 w-full md:w-auto">
                <div class="w-12 h-12 rounded-full bg-blue-600 flex items-center justify-center text-white text-xl shadow-lg shadow-blue-500/30">
                    <i class="fa-solid fa-user"></i>
                </div>
                <div>
                    <h2 class="text-xl font-bold text-white" id="prof-name">نام مشتری</h2>
                    <p class="text-sm text-gray-400 font-mono mt-0.5" id="prof-mobile">0912...</p>
                    <p class="text-xs text-gray-500 mt-0.5" id="prof-email">-</p>
                </div>
            </div>
            <div class="flex gap-2 flex-wrap w-full md:w-auto justify-end">
                <?php if(!isCrmSpecialist()): ?>
                <button onclick="app.openModal('modalActivity')" class="btn-primary px-4 py-2 rounded text-sm flex-grow md:flex-grow-0 justify-center">
                    <i class="fa-solid fa-plus ml-1"></i> ثبت فعالیت
                </button>
                <button onclick="app.openDealModal()" class="btn-primary px-4 py-2 rounded text-sm bg-green-600 hover:bg-green-700 flex-grow md:flex-grow-0 justify-center">
                    <i class="fa-solid fa-handshake ml-1"></i> ثبت معامله
                </button>
                <?php endif; ?>
                <?php if(canAccessSatisfaction()): ?>
                <button onclick="app.openSatisfactionModal()" class="btn-primary px-4 py-2 rounded text-sm bg-purple-600 hover:bg-purple-700 flex-grow md:flex-grow-0 justify-center">
                    <i class="fa-solid fa-star ml-1"></i> رضایت مشتری
                </button>
                <?php endif; ?>
                <?php if(canAccessSupport()): ?>
                <button onclick="app.openSupportModal()" class="btn-primary px-4 py-2 rounded text-sm bg-blue-600 hover:bg-blue-700 flex-grow md:flex-grow-0 justify-center">
                    <i class="fa-solid fa-headset ml-1"></i> ثبت پشتیبانی
                </button>
                <?php endif; ?>
                <button onclick="app.closeModal('modalProfile')" class="text-gray-400 hover:text-red-500 transition"><i class="fa-solid fa-xmark text-2xl"></i></button>
            </div>
        </div>

        <!-- Tabs -->
        <div class="flex border-b border-gray-700 bg-gray-800/30 overflow-x-auto whitespace-nowrap">
            <button onclick="app.switchProfileTab('info')" class="profile-tab active px-6 py-3 text-sm font-bold text-yellow-500 border-b-2 border-yellow-500">اطلاعات</button>
            <button onclick="app.switchProfileTab('deals')" class="profile-tab px-6 py-3 text-sm text-gray-400 hover:text-white">معاملات</button>
            <button onclick="app.switchProfileTab('activities')" class="profile-tab px-6 py-3 text-sm text-gray-400 hover:text-white">فعالیت‌ها</button>
            <?php if(canAccessSatisfaction()): ?>
            <button onclick="app.switchProfileTab('satisfactions')" class="profile-tab px-6 py-3 text-sm text-gray-400 hover:text-white">رضایت مشتری</button>
            <?php endif; ?>
            <?php if(canAccessSupport()): ?>
            <button onclick="app.switchProfileTab('support')" class="profile-tab px-6 py-3 text-sm text-gray-400 hover:text-white">پشتیبانی</button>
            <?php endif; ?>
        </div>

        <!-- Body -->
        <div class="flex-1 overflow-y-auto p-6">
            <!-- Tab: Info -->
            <div id="profile-tab-info" class="profile-tab-content">
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-4">
                    <div class="glass p-4">
                        <div class="text-xs text-gray-400 mb-1">نام</div>
                        <div class="text-white font-bold" id="prof-info-name">-</div>
                    </div>
                    <div class="glass p-4">
                        <div class="text-xs text-gray-400 mb-1">موبایل</div>
                        <div class="text-white font-bold" id="prof-info-mobile">-</div>
                    </div>
                    <div class="glass p-4">
                        <div class="text-xs text-gray-400 mb-1">شماره دوم</div>
                        <div class="text-white font-bold" id="prof-info-mobile2">-</div>
                    </div>
                    <div class="glass p-4">
                        <div class="text-xs text-gray-400 mb-1">موبایل سوم</div>
                        <div class="text-white font-bold" id="prof-info-mobile3">-</div>
                    </div>
                    <div class="glass p-4">
                        <div class="text-xs text-gray-400 mb-1">موبایل چهارم</div>
                        <div class="text-white font-bold" id="prof-info-mobile4">-</div>
                    </div>
                    <div class="glass p-4">
                        <div class="text-xs text-gray-400 mb-1">مسئول لید</div>
                        <div class="text-white font-bold" id="prof-info-owner">-</div>
                    </div>
                    <div class="glass p-4">
                        <div class="text-xs text-gray-400 mb-1">مسئول قبلی</div>
                        <div class="text-white font-bold" id="prof-info-prev-owner">-</div>
                    </div>
                    <div class="glass p-4">
                        <div class="text-xs text-gray-400 mb-1">مرحله کاریز</div>
                        <div class="text-white font-bold" id="prof-info-stage">-</div>
                    </div>
                    <div class="glass p-4">
                        <div class="text-xs text-gray-400 mb-1">تاریخ ثبت لید</div>
                        <div class="text-white font-bold" id="prof-info-register">-</div>
                    </div>
                    <div class="glass p-4">
                        <div class="text-xs text-gray-400 mb-1">وضعیت فروش</div>
                        <div class="text-white font-bold" id="prof-info-sale-status">-</div>
                    </div>
                    <div class="glass p-4">
                        <div class="text-xs text-gray-400 mb-1">کد ملی</div>
                        <div class="text-white font-bold" id="prof-info-national-id">-</div>
                    </div>
                    <div class="glass p-4">
                        <div class="text-xs text-gray-400 mb-1">شهر</div>
                        <div class="text-white font-bold" id="prof-info-city">-</div>
                    </div>
                    <div class="glass p-4">
                        <div class="text-xs text-gray-400 mb-1">شغل</div>
                        <div class="text-white font-bold" id="prof-info-job">-</div>
                    </div>
                    <div class="glass p-4">
                        <div class="text-xs text-gray-400 mb-1">شرح شغل</div>
                        <div class="text-white font-bold text-sm" id="prof-info-job-desc">-</div>
                    </div>
                    <div class="glass p-4" id="prof-info-source-container">
                        <div class="text-xs text-gray-400 mb-1">شیوه آشنایی</div>
                        <div class="text-white font-bold text-sm" id="prof-info-source">-</div>
                        <div class="text-[11px] text-gray-500" id="prof-info-source-detail"></div>
                    </div>
                    <div class="glass p-4">
                        <div class="text-xs text-gray-400 mb-1">موضوع محتوا</div>
                        <div class="text-white font-bold text-sm" id="prof-info-topic">-</div>
                    </div>
                    <div class="glass p-4">
                        <div class="text-xs text-gray-400 mb-1">محصولات مشتری</div>
                        <div class="text-white font-bold text-sm" id="prof-info-products">-</div>
                    </div>
                    <div class="glass p-4">
                        <div class="text-xs text-gray-400 mb-1">خدمات درخواستی</div>
                        <div class="text-white font-bold text-sm" id="prof-info-requested-services">-</div>
                    </div>
                    <div class="glass p-4">
                        <div class="text-xs text-gray-400 mb-1">مدت زمان آشنایی</div>
                        <div class="text-white font-bold text-sm" id="prof-info-acq-duration">-</div>
                    </div>
                    <div class="glass p-4">
                        <div class="text-xs text-gray-400 mb-1">اطلاعات تکمیلی</div>
                        <div class="text-white font-bold text-sm" id="prof-info-extra-info">-</div>
                    </div>
                    <div class="glass p-4">
                        <div class="text-xs text-gray-400 mb-1">سطح مشتری</div>
                        <div class="text-white font-bold text-sm" id="prof-info-customer-level">-</div>
                        <div class="text-[11px] text-gray-500" id="prof-info-customer-level-notes"></div>
                    </div>
                    <div class="glass p-4">
                        <div class="text-xs text-gray-400 mb-1">سطح مالی</div>
                        <div class="text-white font-bold text-sm" id="prof-info-financial-level">-</div>
                    </div>
                    <div class="glass p-4">
                        <div class="text-xs text-gray-400 mb-1">تخمین دارایی</div>
                        <div class="text-white font-bold text-sm" id="prof-info-asset">-</div>
                    </div>
                    <div class="glass p-4">
                        <div class="text-xs text-gray-400 mb-1">تخمین درآمد</div>
                        <div class="text-white font-bold text-sm" id="prof-info-income">-</div>
                    </div>
                    <div class="glass p-4">
                        <div class="text-xs text-gray-400 mb-1">وضعیت خرید قبلی</div>
                        <div class="text-white font-bold text-sm" id="prof-info-purchase-status">-</div>
                    </div>
                </div>
                <div class="flex justify-end mt-4">
                    <button id="lead-edit-btn" class="hidden px-3 py-1.5 rounded border border-yellow-500 text-yellow-500 text-xs hover:bg-yellow-500/10" onclick="app.editLeadInfo()">ویرایش اطلاعات</button>
                </div>
                <div class="glass p-4 mt-4">
                    <div class="text-xs text-gray-400 mb-1">توضیحات</div>
                    <p class="text-sm text-gray-200 leading-relaxed whitespace-pre-line" id="prof-info-background">-</p>
                </div>
            </div>
            
            <!-- Tab: Deals -->
            <div id="profile-tab-deals" class="profile-tab-content hidden">
                <div class="mb-4">
                    <button onclick="app.viewDidarDeals(window.currentContactId)" class="btn-primary px-4 py-2 rounded text-sm mb-3">
                        <i class="fa-solid fa-eye ml-1"></i> مشاهده معاملات گذشته از دیدار
                    </button>
                </div>
                <div id="prof-deals" class="space-y-3">
                    <div class="text-center text-gray-500 py-4">در حال بارگذاری...</div>
                </div>
            </div>
            
            <!-- Tab: Activities -->
            <div id="profile-tab-activities" class="profile-tab-content hidden">
                <div class="mb-4">
                    <button onclick="app.viewDidarActivities(window.currentContactId)" class="btn-primary px-4 py-2 rounded text-sm mb-3">
                        <i class="fa-solid fa-eye ml-1"></i> مشاهده فعالیت‌های گذشته از دیدار
                    </button>
                </div>
                <div id="prof-activities" class="space-y-4 relative before:absolute before:top-0 before:right-[19px] before:w-[2px] before:h-full before:bg-gray-800">
                    <div class="text-center text-gray-500 py-4">در حال بارگذاری...</div>
                </div>
            </div>
            
            <!-- Tab: Satisfactions -->
            <?php if(canAccessSatisfaction()): ?>
            <div id="profile-tab-satisfactions" class="profile-tab-content hidden">
                <div id="prof-satisfactions" class="space-y-4">
                    <div class="text-center text-gray-500 py-4">در حال بارگذاری...</div>
                </div>
            </div>
            <?php endif; ?>
            
            <!-- Tab: Support -->
            <?php if(canAccessSupport()): ?>
            <div id="profile-tab-support" class="profile-tab-content hidden">
                <div id="prof-support" class="space-y-4">
                    <div class="text-center text-gray-500 py-4">در حال بارگذاری...</div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Satisfaction Modal -->
<?php if(canAccessSatisfaction()): ?>
<div id="modalSatisfaction" class="fixed inset-0 bg-black/80 hidden z-50 flex items-center justify-center p-4 backdrop-blur-sm">
    <div class="glass w-full max-w-md p-6">
        <div class="flex justify-between items-center mb-4">
            <h3 class="font-bold text-white text-lg">ثبت رضایت مشتری</h3>
            <button onclick="app.closeModal('modalSatisfaction')" class="text-gray-500 hover:text-white"><i class="fa-solid fa-times"></i></button>
        </div>
        <form onsubmit="app.saveSatisfaction(event)" class="space-y-4">
            <input type="hidden" name="contact_id" id="satisfaction-contact-id" value="">
            
            <div>
                <label class="text-sm text-gray-400 mb-2 block">امتیاز رضایت <span class="text-red-500">*</span></label>
                <div class="flex gap-2 justify-center">
                    <input type="radio" name="satisfaction_score" id="score-1" value="1" class="hidden" required>
                    <label for="score-1" class="cursor-pointer text-3xl hover:scale-110 transition" onclick="app.selectSatisfactionScore(1)">⭐</label>
                    <input type="radio" name="satisfaction_score" id="score-2" value="2" class="hidden" required>
                    <label for="score-2" class="cursor-pointer text-3xl hover:scale-110 transition" onclick="app.selectSatisfactionScore(2)">⭐</label>
                    <input type="radio" name="satisfaction_score" id="score-3" value="3" class="hidden" required>
                    <label for="score-3" class="cursor-pointer text-3xl hover:scale-110 transition" onclick="app.selectSatisfactionScore(3)">⭐</label>
                    <input type="radio" name="satisfaction_score" id="score-4" value="4" class="hidden" required>
                    <label for="score-4" class="cursor-pointer text-3xl hover:scale-110 transition" onclick="app.selectSatisfactionScore(4)">⭐</label>
                    <input type="radio" name="satisfaction_score" id="score-5" value="5" class="hidden" required>
                    <label for="score-5" class="cursor-pointer text-3xl hover:scale-110 transition" onclick="app.selectSatisfactionScore(5)">⭐</label>
                </div>
                <div class="text-center mt-2">
                    <span id="satisfaction-score-text" class="text-sm text-gray-400">امتیاز را انتخاب کنید</span>
                </div>
            </div>
            
            <div>
                <label class="text-sm text-gray-400 mb-1 block">یادداشت</label>
                <textarea name="satisfaction_note" placeholder="توضیحات رضایت مشتری (اختیاری)" class="input" rows="4"></textarea>
            </div>
            
            <button type="submit" class="btn-primary w-full py-2.5 rounded-lg">ثبت رضایت</button>
        </form>
    </div>
</div>
<?php endif; ?>

<!-- Support Modal -->
<?php if(canAccessSupport()): ?>
<div id="modalSupport" class="fixed inset-0 bg-black/80 hidden z-50 flex items-center justify-center p-4 backdrop-blur-sm">
    <div class="glass w-full max-w-md p-6">
        <div class="flex justify-between items-center mb-4">
            <h3 class="font-bold text-white text-lg">ثبت پشتیبانی</h3>
            <button onclick="app.closeModal('modalSupport')" class="text-gray-500 hover:text-white"><i class="fa-solid fa-times"></i></button>
        </div>
        <form onsubmit="app.saveSupport(event)" class="space-y-4">
            <input type="hidden" name="contact_id" id="support-contact-id" value="">
            <input type="hidden" name="support_id" id="support-id" value="">
            
            <div>
                <label class="text-sm text-gray-400 mb-2 block">نوع تماس <span class="text-red-500">*</span></label>
                <select name="channel" id="support-channel" required class="input bg-gray-800">
                    <option value="">-- انتخاب کنید --</option>
                    <option value="call">تماس</option>
                    <option value="chat">چت</option>
                    <option value="visit">ویزیت حضوری</option>
                    <option value="email">ایمیل</option>
                </select>
            </div>
            
            <div>
                <label class="text-sm text-gray-400 mb-2 block">جهت <span class="text-red-500">*</span></label>
                <select name="direction" id="support-direction" required class="input bg-gray-800">
                    <option value="">-- انتخاب کنید --</option>
                    <option value="incoming">ورودی</option>
                    <option value="outgoing">خروجی</option>
                </select>
            </div>
            
            <div>
                <label class="text-sm text-gray-400 mb-1 block">نتیجه پشتیبانی <span class="text-red-500">*</span></label>
                <textarea name="result_note" id="support-result-note" placeholder="توضیحات نتیجه پشتیبانی" class="input" rows="5" required></textarea>
            </div>
            
            <button type="submit" class="btn-primary w-full py-2.5 rounded-lg">
                <i class="fa-solid fa-save ml-2"></i> ثبت پشتیبانی
            </button>
        </form>
    </div>
</div>
<?php endif; ?>

<!-- Didar Search Modal -->
<?php if(isAdmin()): ?>
<div id="modalDidarSearch" class="fixed inset-0 bg-black/80 hidden z-50 flex items-center justify-center p-4 backdrop-blur-sm">
    <div class="glass w-full max-w-4xl xl:max-w-5xl h-[90vh] flex flex-col overflow-hidden">
        <div class="p-6 border-b border-gray-700 flex justify-between items-center">
            <h3 class="font-bold text-white text-lg">جستجو در دیدار</h3>
            <button onclick="app.closeModal('modalDidarSearch')" class="text-gray-500 hover:text-white"><i class="fa-solid fa-times"></i></button>
        </div>
        <div class="flex-1 overflow-y-auto p-6">
            <form onsubmit="app.searchDidar(event)" class="mb-6">
                <div class="flex flex-col md:flex-row gap-3">
                    <input type="text" name="phone" id="didar-search-phone" placeholder="شماره تلفن (10 رقم)" class="input flex-1" maxlength="11">
                    <input type="text" name="keywords" id="didar-search-keywords" placeholder="یا نام/کلمات کلیدی" class="input flex-1">
                    <button type="submit" class="btn-primary px-6 py-2 rounded-lg">جستجو</button>
                </div>
            </form>
            <div id="didar-search-results" class="space-y-3">
                <p class="text-center text-gray-500 py-8">برای جستجو، شماره تلفن یا کلمات کلیدی را وارد کنید</p>
            </div>
        </div>
    </div>
</div>

<!-- Didar Person Details Modal -->
<div id="modalDidarPerson" class="fixed inset-0 bg-black/80 hidden z-50 flex items-center justify-center p-4 backdrop-blur-sm">
    <div class="glass w-full max-w-5xl xl:max-w-6xl h-[90vh] flex flex-col overflow-hidden">
        <div class="p-6 border-b border-gray-700 flex justify-between items-center">
            <h3 class="font-bold text-white text-lg" id="didar-person-name">جزئیات شخص از دیدار</h3>
            <button onclick="app.closeModal('modalDidarPerson')" class="text-gray-500 hover:text-white"><i class="fa-solid fa-times"></i></button>
        </div>
        <div class="flex-1 overflow-y-auto p-6">
            <div id="didar-person-details" class="space-y-6">
                <div class="text-center text-gray-500 py-8">در حال بارگذاری...</div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Didar Deals Modal (for all users) -->
<div id="modalDidarDeals" class="fixed inset-0 bg-black/80 hidden z-50 flex items-center justify-center p-4 backdrop-blur-sm">
    <div class="glass w-full max-w-5xl xl:max-w-6xl h-[90vh] flex flex-col overflow-hidden">
        <div class="p-6 border-b border-gray-700 flex justify-between items-center">
            <h3 class="font-bold text-white text-lg">معاملات گذشته از دیدار</h3>
            <button onclick="app.closeModal('modalDidarDeals')" class="text-gray-500 hover:text-white"><i class="fa-solid fa-times"></i></button>
        </div>
        <div class="flex-1 overflow-y-auto p-6">
            <div id="didar-deals-list" class="space-y-3">
                <div class="text-center text-gray-500 py-8">در حال بارگذاری...</div>
            </div>
        </div>
    </div>
</div>

<!-- Didar Activities Modal (for all users) -->
<div id="modalDidarActivities" class="fixed inset-0 bg-black/80 hidden z-50 flex items-center justify-center p-4 backdrop-blur-sm">
    <div class="glass w-full max-w-5xl xl:max-w-6xl h-[90vh] flex flex-col overflow-hidden">
        <div class="p-6 border-b border-gray-700 flex justify-between items-center">
            <h3 class="font-bold text-white text-lg">فعالیت‌های گذشته از دیدار</h3>
            <button onclick="app.closeModal('modalDidarActivities')" class="text-gray-500 hover:text-white"><i class="fa-solid fa-times"></i></button>
        </div>
        <div class="flex-1 overflow-y-auto p-6">
            <div id="didar-activities-list" class="space-y-3">
                <div class="text-center text-gray-500 py-8">در حال بارگذاری...</div>
            </div>
        </div>
    </div>
</div>

<!-- Deal Details Modal -->
<div id="modalDealDetails" class="fixed inset-0 bg-black/80 hidden z-50 flex items-center justify-center p-4 backdrop-blur-sm">
    <div class="glass w-full max-w-5xl xl:max-w-6xl h-[90vh] flex flex-col overflow-hidden">
        <div class="p-6 border-b border-gray-700 flex justify-between items-center">
            <h3 class="font-bold text-white text-lg" id="deal-details-title">جزئیات معامله</h3>
            <button onclick="app.closeModal('modalDealDetails')" class="text-gray-500 hover:text-white"><i class="fa-solid fa-times"></i></button>
        </div>
        <div class="flex-1 overflow-y-auto p-6">
            <!-- Tabs -->
            <div class="flex gap-2 mb-6 border-b border-gray-700 overflow-x-auto whitespace-nowrap">
                <button onclick="app.showDealDetailsTab('info')" id="deal-tab-info" class="px-4 py-2 text-sm font-medium text-white border-b-2 border-blue-500">
                    اطلاعات معامله
                </button>
                <button onclick="app.showDealDetailsTab('activities')" id="deal-tab-activities" class="px-4 py-2 text-sm font-medium text-gray-400 hover:text-white border-b-2 border-transparent">
                    فعالیت‌ها
                </button>
            </div>
            
            <!-- Tab Content: Info -->
            <div id="deal-details-info" class="deal-details-tab">
                <div id="deal-details-content" class="space-y-6">
                    <div class="text-center text-gray-500 py-8">در حال بارگذاری...</div>
                </div>
            </div>
            
            <!-- Tab Content: Activities -->
            <div id="deal-details-activities" class="deal-details-tab hidden">
                <div id="deal-activities-content" class="space-y-3">
                    <div class="text-center text-gray-500 py-8">در حال بارگذاری...</div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Activity Modal -->
<div id="modalActivity" class="fixed inset-0 bg-black/80 hidden z-50 flex items-center justify-center p-4 backdrop-blur-sm">
    <div class="glass w-full max-w-lg md:max-w-2xl p-6 max-h-[90vh] overflow-y-auto">
        <div class="flex justify-between items-center mb-4">
            <h3 class="font-bold text-white text-lg">ثبت فعالیت جدید</h3>
            <button onclick="app.closeModal('modalActivity')" class="text-gray-500 hover:text-white"><i class="fa-solid fa-times"></i></button>
        </div>

        <div id="activity-lead-info-display" class="mb-4 p-3 bg-yellow-900/40 border border-yellow-500/50 rounded-lg hidden shadow-lg shadow-yellow-900/20">
            <div class="text-xs text-yellow-300/80 mb-1">در حال ثبت فعالیت برای لید:</div>
            <div class="font-bold text-yellow-100 text-base" id="activity-lead-name-text">---</div>
        </div>

        <form onsubmit="app.saveActivity(event)" class="space-y-3">
                <input type="hidden" name="contact_id" id="activity-contact-id" value="">
                <input type="hidden" name="deal_id" id="activity-deal-id" value="">
            <select name="activity_type_id" required class="input bg-gray-800" id="activity-type-select">
                <option value="">-- انتخاب نوع فعالیت --</option>
            </select>
            <input type="hidden" name="direction" id="activity-direction" value="outgoing">
            
            <div>
                <label class="text-xs text-gray-400 mb-1 block">مرحله کاریز فعلی</label>
                <div id="activity-current-stage-display" class="input bg-gray-800 text-gray-300 py-2.5 px-3 rounded-lg border border-gray-700">
                    <span class="text-sm">در حال بارگذاری...</span>
                </div>
                <input type="hidden" name="current_stage" id="activity-current-stage" value="keep_current">
            </div>
            
            <!-- Purchase question removed from Activity Modal as per user request to only appear during first lead edit.
            <div id="purchase-question-container">
                <select name="has_previous_purchase_other_number" class="input bg-gray-800" id="activity-has-purchase" onchange="app.handlePurchaseOtherNumberChange()">
                    <option value="">-- آیا این لید قبلاً خرید دیگری با شماره دیگری داشته است؟ --</option>
                    <option value="1">بله</option>
                    <option value="0">خیر</option>
                </select>
                
                <div id="previous-purchase-number-field" class="hidden">
                    <label class="text-xs text-gray-400 mb-1 block">شماره تماس خرید قبلی</label>
                    <input type="text" name="previous_purchase_number" placeholder="شماره تماسی که خرید قبلی با آن انجام شده" class="input">
                </div>
            </div>
            -->
            
            <textarea name="result_note" placeholder="نتیجه فعالیت" class="input h-24 resize-none" id="activity-result-note" required></textarea>
            
            <div>
                <label class="text-xs text-gray-400 mb-1 block">انتخاب معامله (اختیاری)</label>
                <select name="deal_id" id="activity-deal-select" class="input bg-gray-800" onchange="app.handleActivityDealSelection()">
                    <option value="">-- انتخاب معامله مرتبط (اختیاری) --</option>
                </select>
                <p class="text-[11px] text-amber-300 mt-1">برای تغییر مرحله کاریز، معامله را انتخاب کنید. برای فعالیت‌های عمومی روی لید، انتخاب معامله اختیاری است.</p>
            </div>
            
            <div id="activity-pipeline-stage-container">
                <label class="text-xs text-gray-400 mb-1 block">مرحله کاریز معامله پس از فعالیت <span class="text-red-500">*</span></label>
                <select name="pipeline_stage" class="input bg-gray-800" id="activity-virtual-stage" required>
                    <option value="">-- انتخاب مرحله --</option>
                    <option value="تماس عدم پاسخ">تماس عدم پاسخ</option>
                    <option value="تماس پیگیری">تماس پیگیری</option>
                    <option value="ارسال لینک پرداخت">ارسال لینک پرداخت</option>
                    <option value="پرداخت">پرداخت</option>
                    <option value="پیگیری مانده حساب">پیگیری مانده حساب</option>

                    <option value="پشتیبانی">پشتیبانی</option>
                    <option value="ارجاع به CRM">ارجاع به CRM</option>
                    <option value="deal_failed">معامله ناموفق</option>
                    <option value="deal_success">معامله موفق</option>
                </select>
            </div>
            
            <div id="referral-extra" class="hidden bg-gray-900/50 p-3 rounded">
                <p class="text-xs text-gray-400 mb-2">شماره‌های ثبت‌شده: <span id="referral-phones" class="text-gray-200">-</span></p>
                <textarea name="referral_note" placeholder="توضیح ارجاع به کارشناس CRM" class="input h-20 resize-none"></textarea>
            </div>
            
	            <div id="failure-reason-extra" class="hidden bg-gray-900/50 p-3 rounded">
	                <label class="text-xs text-gray-400 mb-2 block">دلیل عدم موفقیت <span class="text-red-500">*</span></label>
	                <select name="failure_reason" id="activity-failure-reason" class="input bg-gray-800" onchange="app.toggleActivityFailureOtherReason()">
	                    <option value="">-- انتخاب دلیل --</option>
	                    <option value="no_financial_ability">عدم توان مالی</option>
	                    <option value="no_purchase_intent">فعلا قصد خرید ندارد</option>
	                    <option value="competitor_purchase">خرید از رقبا</option>
	                    <option value="wrong_number">شماره اشتباه</option>
	                    <option value="irrelevant_lead">لید نامرتبط</option>
	                    <option value="other">سایر</option>
	                </select>
	                <div id="activity-failure-other-reason" class="mt-3">
	                    <label class="text-xs text-gray-400 mb-2 block">توضیحات <span class="text-red-500">*</span></label>
	                    <textarea name="failure_other_description" id="activity-failure-other-description" class="input h-24 resize-none" placeholder="لطفاً توضیحات دلیل عدم موفقیت را وارد کنید"></textarea>
                </div>
            </div>
            
            <!-- Schedule for future -->
            <div class="border-t border-gray-700 pt-3">
                <label class="flex items-center gap-2 text-sm text-gray-300 mb-3">
                    <input type="checkbox" name="is_scheduled" id="activity-is-scheduled" class="w-4 h-4" onchange="app.toggleActivityScheduleFields()">
                    <span>فعالیت برای آینده</span>
                </label>
                
                <div id="activity-schedule-fields" class="hidden space-y-4">
                    <div class="bg-gradient-to-br from-blue-900/30 to-purple-900/30 p-4 rounded-lg border border-blue-500/20">
                        <label class="text-sm text-gray-200 mb-3 block font-semibold flex items-center gap-2">
                            <i class="fa-solid fa-calendar-days text-blue-400"></i>
                            <span>تاریخ و زمان انجام فعالیت</span>
                        </label>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                            <div>
                                <label class="text-xs text-gray-400 mb-2 block">تاریخ</label>
                                <div class="relative">
                                    <input type="text" name="due_date" id="activity-due-date" class="input bg-gray-800/80 border-blue-500/30 focus:border-blue-500 focus:ring-2 focus:ring-blue-500/20" placeholder="انتخاب تاریخ" readonly>
                                    <i class="fa-solid fa-calendar absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 pointer-events-none"></i>
                                </div>
                                <input type="hidden" id="activity-due-date-gregorian" name="due_date_gregorian">
                            </div>
                            <div>
                                <label class="text-xs text-gray-400 mb-2 block">ساعت</label>
                                <div class="flex gap-2">
                                    <select id="activity-due-hour" class="input bg-gray-800/80 border-blue-500/30 focus:border-blue-500 focus:ring-2 focus:ring-blue-500/20 text-center">
                                        <option value="">ساعت</option>
                                    </select>
                                    <span class="text-gray-400 self-center">:</span>
                                    <select id="activity-due-minute" class="input bg-gray-800/80 border-blue-500/30 focus:border-blue-500 focus:ring-2 focus:ring-blue-500/20 text-center">
                                        <option value="">دقیقه</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="mt-3 text-xs text-gray-500 flex items-center gap-2">
                            <i class="fa-solid fa-info-circle"></i>
                            <span>تاریخ و زمان را انتخاب کنید</span>
                        </div>
                    </div>
                    
                    <label class="flex items-center gap-2 text-sm text-gray-300">
                        <input type="checkbox" name="reminder_enabled" id="activity-reminder-enabled" class="w-4 h-4" onchange="app.toggleActivityReminderFields()">
                        <span>فعال کردن یادآوری</span>
                    </label>
                    
                    <div id="activity-reminder-fields" class="hidden">
                        <label class="text-xs text-gray-400 mb-1 block">زمان یادآوری</label>
                        <div class="grid grid-cols-2 gap-2">
                            <div>
                                <label class="text-xs text-gray-500 mb-1 block">ساعت قبل</label>
                                <select name="reminder_offset_hours" id="activity-reminder-hours" class="input bg-gray-800 text-sm">
                                    <option value="0">0 ساعت</option>
                                    <option value="1">1 ساعت</option>
                                    <option value="2">2 ساعت</option>
                                    <option value="4">4 ساعت</option>
                                    <option value="8">8 ساعت</option>
                                    <option value="12">12 ساعت</option>
                                    <option value="24" selected>1 روز</option>
                                    <option value="48">2 روز</option>
                                    <option value="72">3 روز</option>
                                    <option value="168">1 هفته</option>
                                </select>
                            </div>
                            <div>
                                <label class="text-xs text-gray-500 mb-1 block">دقیقه قبل</label>
                                <select name="reminder_offset_minutes" id="activity-reminder-minutes" class="input bg-gray-800 text-sm">
                                    <option value="0" selected>0 دقیقه</option>
                                    <option value="5">5 دقیقه</option>
                                    <option value="10">10 دقیقه</option>
                                    <option value="15">15 دقیقه</option>
                                    <option value="30">30 دقیقه</option>
                                </select>
                            </div>
                        </div>
                        <input type="hidden" name="reminder_offset_minutes" id="reminder-offset-total">
                    </div>
                </div>
            </div>
            
            <label class="flex items-center gap-2 text-sm text-gray-300">
                <input type="checkbox" name="is_done" class="w-4 h-4">
                <span>انجام شده</span>
            </label>
            <button type="submit" class="btn-primary w-full py-2.5 rounded-lg">ثبت فعالیت</button>
        </form>
    </div>
</div>

<!-- Deal Modal -->
<div id="modalDeal" class="fixed inset-0 bg-black/80 hidden z-50 flex items-center justify-center p-4 backdrop-blur-sm overflow-y-auto">
    <div class="glass w-full max-w-4xl my-8 max-h-[90vh] overflow-y-auto p-4 sm:p-6">
        <div class="flex justify-between items-start mb-4">
            <div>
                <p class="text-xs text-gray-400 mb-1">معامله مرتبط با لید</p>
                <h3 class="font-bold text-white text-lg" id="deal-modal-title">ثبت معامله جدید</h3>
            </div>
            <button onclick="app.closeModal('modalDeal')" class="text-gray-500 hover:text-white"><i class="fa-solid fa-times"></i></button>
        </div>

        <div id="deal-lead-info-display" class="mb-4 p-3 bg-yellow-900/40 border border-yellow-500/50 rounded-lg hidden shadow-lg shadow-yellow-900/20">
            <div class="text-xs text-yellow-300/80 mb-1">در حال ثبت معامله برای لید:</div>
            <div class="font-bold text-yellow-100 text-base" id="deal-lead-name-text">---</div>
        </div>

        <!-- Lead summary inside deal modal -->
        <div class="bg-gray-900/40 border border-gray-800 rounded-lg p-4 space-y-3 mb-5">
            <div class="flex flex-col md:flex-row md:items-start md:justify-between gap-4">
                <div class="space-y-2">
                    <div class="text-xs text-gray-400">نام لید</div>
                    <div class="text-lg font-bold text-white" id="deal-summary-name">-</div>
                    <div class="flex flex-wrap gap-3 text-xs text-gray-400">
                        <span>مسئول فعلی: <span id="deal-summary-owner" class="text-gray-200">-</span></span>
                        <span>مسئول قبلی: <span id="deal-summary-prev-owner" class="text-gray-200">-</span></span>
                        <span>وضعیت فروش: <span id="deal-summary-sale-status" class="text-gray-200">-</span></span>
                    </div>
                </div>
                <div class="text-left space-y-2">
                    <div class="text-xs text-gray-400">مرحله کاریز معامله</div>
                    <div id="deal-summary-stage" class="inline-flex items-center px-3 py-1 rounded-full bg-blue-900/40 text-blue-200 text-sm">-</div>
                </div>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-4 gap-3 text-xs text-gray-400">
                <div class="bg-gray-800/40 p-2 rounded border border-gray-800">
                    <div class="text-[11px] mb-1">موبایل اصلی</div>
                    <div id="deal-summary-mobile" class="text-sm text-gray-100 font-bold">-</div>
                </div>
                <div class="bg-gray-800/40 p-2 rounded border border-gray-800">
                    <div class="text-[11px] mb-1">موبایل دوم</div>
                    <div id="deal-summary-mobile2" class="text-sm text-gray-100 font-bold">-</div>
                </div>
                <div class="bg-gray-800/40 p-2 rounded border border-gray-800">
                    <div class="text-[11px] mb-1">موبایل سوم</div>
                    <div id="deal-summary-mobile3" class="text-sm text-gray-100 font-bold">-</div>
                </div>
                <div class="bg-gray-800/40 p-2 rounded border border-gray-800">
                    <div class="text-[11px] mb-1">موبایل چهارم</div>
                    <div id="deal-summary-mobile4" class="text-sm text-gray-100 font-bold">-</div>
                </div>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-3 text-xs text-gray-400">
                <div class="bg-gray-800/40 p-2 rounded border border-gray-800">
                    <div class="text-[11px] mb-1">شهر</div>
                    <div id="deal-summary-city" class="text-sm text-gray-100">-</div>
                </div>
                <div class="bg-gray-800/40 p-2 rounded border border-gray-800">
                    <div class="text-[11px] mb-1">شغل</div>
                    <div id="deal-summary-job" class="text-sm text-gray-100">-</div>
                </div>
                <div class="bg-gray-800/40 p-2 rounded border border-gray-800 hidden">
                    <div class="text-[11px] mb-1">کد دیدار</div>
                    <div id="deal-summary-didar-id-box" class="text-sm text-gray-100">-</div>
                </div>
            </div>
            <div class="flex flex-wrap gap-2">
                <button type="button" class="btn-primary px-4 py-2 text-sm" onclick="app.startActivityForDeal()">ثبت فعالیت</button>
                <button type="button" class="px-4 py-2 rounded-lg border border-gray-700 text-gray-200 hover:border-yellow-500 transition text-sm" onclick="app.showDealFormTab('info')">ثبت اطلاعات معامله</button>
                <button type="button" class="px-4 py-2 rounded-lg border border-gray-700 text-gray-200 hover:border-yellow-500 transition text-sm" onclick="app.scrollToDealPayments()">ثبت پرداخت ها</button>
                <button type="button" class="px-4 py-2 rounded-lg border border-gray-700 text-gray-200 hover:border-yellow-500 transition text-sm" onclick="app.openCourseFromDeal()">برگزاری دوره</button>
                <button type="button" class="px-4 py-2 rounded-lg border border-gray-700 text-gray-200 hover:border-yellow-500 transition text-sm" onclick="app.openSupportFromDeal()">پشتیبانی</button>
                <?php if(isAdmin()): ?>
                <button type="button" class="btn-danger px-4 py-2 text-sm" onclick="app.deleteDealFromModal()">حذف معامله</button>
                <button type="button" class="btn-secondary px-4 py-2 text-sm" onclick="app.reactivateDealFromModal()" id="reactivate-deal-btn" style="display:none;">فعال‌سازی مجدد</button>
                <?php endif; ?>
            </div>
        </div>

        <div class="flex flex-wrap gap-2 mb-3">
            <button type="button" id="deal-tab-btn-info" class="px-3 py-1.5 text-sm rounded bg-gray-800 text-white border border-gray-700" onclick="app.showDealFormTab('info')">اطلاعات معامله</button>
            <button type="button" id="deal-tab-btn-payments" class="px-3 py-1.5 text-sm rounded text-gray-300 border border-gray-700" onclick="app.showDealFormTab('payments')">پرداخت‌ها</button>
            <button type="button" id="deal-tab-btn-activities" class="px-3 py-1.5 text-sm rounded text-gray-300 border border-gray-700 flex items-center gap-2" onclick="app.showDealFormTab('activities')">
                فعالیت‌ها
                <span id="deal-activities-badge" class="text-[10px] px-2 py-0.5 rounded-full bg-gray-700 text-gray-200">0</span>
            </button>
        </div>

        <div id="deal-form-tab-activities" class="hidden space-y-3">
            <div class="flex items-center justify-between mb-2">
                <h4 class="font-bold text-white text-sm">فعالیت‌های انجام‌شده</h4>
                <button type="button" class="btn-primary px-3 py-1 text-xs flex items-center gap-1" onclick="app.startActivityForDeal()">
                    <i class="fa-solid fa-plus"></i> ثبت فعالیت جدید
                </button>
            </div>
            <div id="deal-activities-inline" class="space-y-2 bg-gray-900/40 border border-gray-800 rounded-lg p-3 max-h-96 overflow-y-auto">
                <div class="text-center text-gray-500 py-4">فعالیتی یافت نشد</div>
            </div>
        </div>

        <form onsubmit="app.saveDeal(event)" class="space-y-4" id="deal-form">
            <input type="hidden" name="deal_id" id="deal-id" value="">
            <input type="hidden" name="contact_id" id="deal-contact-id" value="">
            <input type="hidden" id="deal-user-name" value="">
            <input type="hidden" id="deal-user-mobile" value="">

            <div id="deal-form-tab-info" class="hidden space-y-4">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="text-xs text-gray-400 mb-1 block">خدمات قابل ارائه <span class="text-red-500">*</span></label>
                        <select name="title" id="deal-title" required class="input bg-gray-800">
                            <option value="">-- انتخاب خدمات قابل ارائه --</option>
                        </select>
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                        <input type="text" inputmode="numeric" name="service_cost" id="deal-service-cost" placeholder="هزینه خدمات (تومان)" class="input money-input" autocomplete="off" required>
                        <input type="text" name="price_list_code" id="deal-price-list-code" placeholder="کد لیست قیمت" class="input" required>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="text-xs text-gray-400 mb-1 block">تخفیف</label>
                        <select name="has_discount" id="deal-has-discount" class="input bg-gray-800" onchange="app.toggleDiscountFields()">
                            <option value="0">ندارد</option>
                            <option value="1">دارد</option>
                        </select>
                        <div id="discount-fields" class="hidden space-y-3 mt-3">
                            <select name="discount_type" id="deal-discount-type" class="input bg-gray-800" onchange="app.toggleDiscountOccasion()">
                                <option value="">-- انتخاب نوع تخفیف --</option>
                                <option value="occasion">مناسبتی</option>
                                <option value="individual">فردی</option>
                                <option value="refund">مرجوعی</option>
                            </select>
                            <div id="discount-occasion-field" class="hidden">
                                <select name="discount_occasion" id="deal-discount-occasion" class="input bg-gray-800" onchange="app.toggleCustomOccasion()">
                                    <option value="">-- انتخاب مناسبتی --</option>
                                    <option value="black_friday">بلک فرایدی</option>
                                    <option value="teacher_birthday">تولد استاد</option>
                                    <option value="nowruz">عید نوروز</option>
                                    <option value="other">سایر</option>
                                </select>
                                <input type="text" name="discount_occasion_custom" id="deal-discount-occasion-custom" placeholder="عنوان مناسبتی (برای سایر)" class="input mt-2 hidden">
                            </div>
                            <input type="text" inputmode="numeric" name="discount_amount" id="deal-discount-amount" placeholder="مبلغ تخفیف (تومان)" class="input money-input" autocomplete="off">

                            <div id="refund-fields" class="hidden space-y-2">
                                <input type="text" inputmode="numeric" name="refund_amount" id="deal-refund-amount" placeholder="مبلغ مرجوعی (تومان)" class="input money-input" autocomplete="off">
                                <textarea name="refund_description" id="deal-refund-description" placeholder="توضیحات مرجوعی" class="input h-20 resize-none"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="space-y-3">
                        <input type="text" inputmode="numeric" name="payable_amount" id="deal-payable-amount" placeholder="مبلغ قابل پرداخت (تومان)" class="input money-input" autocomplete="off" required>
                        <textarea name="payment_conditions" id="deal-payment-conditions" placeholder="شرایط پرداخت (توضیحات کامل)" class="input h-24 resize-none" required></textarea>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 border-t border-gray-800 pt-4">
                    <div>
                        <label class="text-xs text-gray-400 mb-2 block">وضعیت معامله <span class="text-red-500">*</span></label>
                        <select name="deal_status" id="deal-status" class="input bg-gray-800" required onchange="app.handleDealStatusChange()">
                            <option value="">انتخاب وضعیت</option>
                            <option value="pending">معامله جاری</option>
                            <option value="won">معامله موفق</option>
                            <option value="lost">معامله ناموفق</option>
                        </select>
                    </div>
                    <div>
                        <label class="text-xs text-gray-400 mb-2 block">مرحله کاریز معامله <span class="text-red-500" id="pipeline-stage-required-indicator">*</span></label>
                        <select name="pipeline_stage" id="deal-pipeline-stage" class="input bg-gray-800" required onchange="app.handleDealPipelineStageChange()">
                            <option value="">انتخاب مرحله</option>
                            <option value="تماس عدم پاسخ">تماس عدم پاسخ</option>
                            <option value="تماس پیگیری">تماس پیگیری</option>
                            <option value="ارسال لینک پرداخت">ارسال لینک پرداخت</option>
                            <option value="پرداخت">پرداخت</option>
                            <option value="پیگیری مانده حساب">پیگیری مانده حساب</option>
                            <option value="برگزاری دوره">برگزاری دوره</option>

                            <option value="پشتیبانی">پشتیبانی</option>
                            <option value="ارجاع به CRM">ارجاع به CRM</option>
                            <option value="معامله ناموفق">معامله ناموفق</option>
                            <option value="deal_success">معامله موفق</option>
                        </select>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-2">
                    <div>
                        <label class="text-xs text-gray-400 mb-1 block">وضعیت فعلی معامله</label>
                        <div id="deal-current-status" class="input bg-gray-900 text-gray-200">-</div>
                    </div>
                    <div>
                        <label class="text-xs text-gray-400 mb-1 block">مرحله فعلی کاریز</label>
                        <div id="deal-current-stage" class="input bg-gray-900 text-gray-200">-</div>
                    </div>
                </div>

                <div class="border-t border-gray-700 pt-4 mt-2">
                    <div class="flex justify-between items-center mb-2">
                        <label class="text-xs text-gray-400">محصولات معامله</label>
                        <?php if(isAdmin()): ?>
                        <button type="button" class="btn-primary px-3 py-1 text-xs" onclick="app.addProductPrompt()">افزودن محصول</button>
                        <?php endif; ?>
                    </div>
                    <div id="deal-products-list" class="space-y-2 text-sm text-gray-200 hidden"></div>
                </div>

	                <div id="deal-failure-reason-section" class="hidden mt-4">
	                    <label class="text-xs text-gray-400 mb-2 block">دلیل ناموفق بودن <span class="text-red-500">*</span></label>
	                    <select name="failure_reason" id="deal-failure-reason" class="input bg-gray-800" onchange="app.toggleFailureOtherReason()">
	                        <option value="">-- انتخاب دلیل --</option>
	                        <option value="no_financial_ability">عدم توان مالی</option>
	                        <option value="no_purchase_intent">فعلا قصد خرید ندارد</option>
	                        <option value="competitor_purchase">خرید از رقبا</option>
	                        <option value="wrong_number">شماره اشتباه</option>
	                        <option value="irrelevant_lead">لید نامرتبط</option>
	                        <option value="other">سایر</option>
	                    </select>
	                    <div id="deal-failure-other-reason" class="mt-3">
	                        <label class="text-xs text-gray-400 mb-2 block">توضیحات <span class="text-red-500">*</span></label>
	                        <textarea name="failure_other_description" id="deal-failure-other-description" class="input h-24 resize-none" placeholder="لطفاً توضیحات دلیل ناموفق بودن را وارد کنید"></textarea>
                    </div>
                </div>

                <div class="flex gap-3 mt-4">
                    <button type="button" id="deal-info-submit-btn" class="btn-primary w-full py-2.5 rounded" onclick="app.saveDealFromTab('info')">ثبت اطلاعات معامله</button>
                </div>
            </div>

            <div id="deal-form-tab-activities" class="hidden space-y-3">
                <p class="text-sm text-gray-300">برای ثبت فعالیت جدید روی دکمه زیر بزنید. تمام فعالیت‌ها روی معامله انتخاب‌شده اعمال می‌شوند.</p>
                <button type="button" class="btn-primary w-full py-2.5 rounded" onclick="app.startActivityForDeal()">ثبت فعالیت برای این معامله</button>
                <div id="deal-activities-inline" class="space-y-2 bg-gray-900/40 border border-gray-800 rounded-lg p-3 max-h-96 overflow-y-auto">
                    <div class="text-center text-gray-500 py-4">فعالیتی یافت نشد</div>
                </div>
            </div>

            <div id="deal-form-tab-payments" class="hidden space-y-4">
                <div class="flex flex-wrap gap-3 items-center">
                    <button type="button" class="btn-primary px-4 py-2 rounded text-sm" onclick="app.saveDealFromTab('payments')">ثبت پرداخت ها</button>
                </div>
                <div id="deal-payment-details" class="border-t border-gray-700 pt-4">
                    <div class="flex justify-between items-center mb-3">
                        <h4 class="font-bold text-white text-sm">جزئیات پرداخت</h4>
                        <button type="button" id="deal-add-payment-btn" onclick="app.addPaymentRow(null, false)" class="btn-primary px-3 py-1.5 rounded text-xs flex items-center gap-1">
                            <i class="fa-solid fa-plus"></i> افزودن پرداخت
                        </button>
                    </div>
                    <div id="payment-rows" class="space-y-3">
                        <!-- Payment rows will be added here dynamically -->
                    </div>
                </div>
            </div>

            <div class="flex gap-3 mt-4">
                <button type="button" onclick="app.closeModal('modalDeal')" class="flex-1 px-4 py-2.5 rounded-lg border border-gray-700 text-gray-400 hover:text-white hover:border-gray-600 transition">
                    <i class="fa-solid fa-times ml-1"></i> لغو
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Modal انتخاب دلیل ناموفق بودن معامله -->
<div id="modalDealFailed" class="fixed inset-0 bg-black/80 hidden z-50 flex items-center justify-center p-4 backdrop-blur-sm">
    <div class="glass w-full max-w-md p-6">
        <div class="flex justify-between items-center mb-4">
            <h3 class="font-bold text-white text-lg">انتخاب دلیل ناموفق بودن معامله</h3>
            <button onclick="app.closeModal('modalDealFailed')" class="text-gray-500 hover:text-white"><i class="fa-solid fa-times"></i></button>
        </div>
	        <form onsubmit="app.confirmDealFailed(event)" class="space-y-4">
	            <input type="hidden" id="failed-deal-id" value="">
	            <input type="hidden" id="failed-contact-id" value="">
	            
	            <div>
	                <label class="text-xs text-gray-400 mb-2 block">دلیل ناموفق بودن <span class="text-red-500">*</span></label>
	                <select id="failure-reason" class="input bg-gray-800" required onchange="app.toggleFailureOtherReason()">
	                    <option value="">-- انتخاب دلیل --</option>
	                    <option value="no_financial_ability">عدم توان مالی</option>
	                    <option value="no_purchase_intent">فعلا قصد خرید ندارد</option>
	                    <option value="competitor_purchase">خرید از رقبا</option>
	                    <option value="wrong_number">شماره اشتباه</option>
	                    <option value="irrelevant_lead">لید نامرتبط</option>
	                    <option value="other">سایر</option>
	                </select>
	            </div>
            
            <div id="failure-other-reason" class="hidden">
                <label class="text-xs text-gray-400 mb-2 block">توضیحات <span class="text-red-500">*</span></label>
                <textarea id="failure-other-description" class="input h-24 resize-none" placeholder="لطفاً توضیحات را وارد کنید"></textarea>
            </div>
            
            <div class="flex justify-end gap-3">
                <button type="button" onclick="app.closeModal('modalDealFailed')" class="px-4 py-2 rounded-lg border border-gray-700 text-gray-400 hover:text-white">انصراف</button>
                <button type="submit" class="btn-primary px-6 py-2 rounded-lg">تایید</button>
            </div>
        </form>
    </div>
</div>

<!-- Modal برگزاری دوره / پشتیبانی / مرجوعی -->
<div id="modalCourse" class="fixed inset-0 bg-black/80 hidden z-50 flex items-center justify-center p-4 backdrop-blur-sm overflow-y-auto">
    <div class="glass w-full max-w-lg p-6 my-10">
        <div class="flex justify-between items-center mb-4">
            <h3 class="font-bold text-white text-lg">برگزاری دوره / پشتیبانی</h3>
            <button onclick="app.closeModal('modalCourse')" class="text-gray-500 hover:text-white"><i class="fa-solid fa-times"></i></button>
        </div>
        <form onsubmit="app.submitCourseStatus(event)" id="course-form" class="space-y-4">
            <input type="hidden" name="deal_id" id="course-deal-id" value="">
            <input type="hidden" name="contact_id" id="course-contact-id" value="">

            <div class="grid grid-cols-2 gap-3">
                <label class="flex items-center gap-2 text-sm text-gray-300">
                    <input type="checkbox" name="course_virtual" id="course-virtual" class="form-checkbox text-yellow-500">
                    <span>دوره مجازی</span>
                </label>
                <label class="flex items-center gap-2 text-sm text-gray-300">
                    <input type="checkbox" name="course_online" id="course-online" class="form-checkbox text-yellow-500">
                    <span>دوره حضوری/آنلاین</span>
                </label>
            </div>

            <div class="grid grid-cols-2 gap-3">
                <label class="flex items-center gap-2 text-sm text-gray-300">
                    <input type="checkbox" name="access_created" id="course-access-created" class="form-checkbox text-yellow-500">
                    <span>ایجاد دسترسی انجام شده</span>
                </label>
                <label class="flex items-center gap-2 text-sm text-gray-300">
                    <input type="checkbox" name="link_sent" id="course-link-sent" class="form-checkbox text-yellow-500">
                    <span>ارسال لینک دسترسی انجام شده</span>
                </label>
            </div>

            <div>
                <label class="text-xs text-gray-400 mb-1 block">تاریخ برگزاری دوره (برای حضوری/آنلاین)</label>
                <input type="text" name="course_date" id="course-date-jalali" class="input bg-gray-800" placeholder="۱۴۰۳/۰۱/۱۵">
            </div>

            <div>
                <label class="text-xs text-gray-400 mb-1 block">مرحله بعدی</label>
                <select name="next_stage" id="course-next-stage" class="input bg-gray-800">

                    <option value="پشتیبانی">پشتیبانی</option>
                </select>
            </div>

            <div class="border-t border-gray-700 pt-3">
                <label class="flex items-center gap-2 text-sm text-red-400">
                    <input type="checkbox" name="refund" id="course-refund" class="form-checkbox text-red-500" onchange="app.toggleRefundSection()">
                    <span>مرجوعی</span>
                </label>
                <div id="refund-section" class="hidden mt-3">
                    <label class="text-xs text-gray-400 mb-1 block">دلیل مرجوعی</label>
                    <textarea name="refund_reason" id="course-refund-reason" class="input h-20 resize-none" placeholder="دلیل مرجوعی را توضیح دهید"></textarea>
                </div>
            </div>

            <div class="flex gap-3 mt-4">
                <button type="button" onclick="app.closeModal('modalCourse')" class="flex-1 px-4 py-2.5 rounded-lg border border-gray-700 text-gray-400 hover:text-white hover:border-gray-600 transition">
                    <i class="fa-solid fa-times ml-1"></i> لغو
                </button>
                <button type="submit" class="flex-1 btn-primary py-2.5 rounded-lg">ثبت</button>
            </div>
        </form>
    </div>
</div>

<!-- Lead Modal -->
<div id="modalLead" class="fixed inset-0 bg-black/80 hidden z-50 flex items-center justify-center p-4 backdrop-blur-sm overflow-y-auto">
    <div class="glass w-full max-w-3xl p-6 my-10">
        <div class="flex justify-between items-center mb-4">
            <h3 class="font-bold text-white text-lg" id="lead-modal-title">افزودن لید جدید</h3>
            <button onclick="app.closeModal('modalLead')" class="text-gray-500 hover:text-white"><i class="fa-solid fa-times"></i></button>
        </div>
        <form onsubmit="app.saveLead(event)" class="space-y-4" id="lead-form">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                <input type="text" name="full_name" placeholder="نام و نام خانوادگی" class="input">
                <input type="text" name="national_id" placeholder="کد ملی" class="input">
                <select name="owner_didar_id" id="lead-owner-select" class="input bg-gray-800" required>
                    <option value="">-- انتخاب مسئول از دیدار --</option>
                </select>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                <input type="text" name="mobile_phone" id="lead-mobile-phone" placeholder="شماره تماس اصلی" class="input" required maxlength="10" inputmode="numeric" pattern="[1-9][0-9]{9}" title="لطفاً 10 رقم بدون صفر وارد کنید">
                <input type="text" name="secondary_mobile_phone" placeholder="شماره تماس دوم" class="input" maxlength="10" inputmode="numeric" pattern="[1-9][0-9]{9}" title="لطفاً 10 رقم بدون صفر وارد کنید">
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                <input type="text" name="mobile_phone_3" placeholder="شماره تماس سوم" class="input" maxlength="10" inputmode="numeric" pattern="[1-9][0-9]{9}" title="لطفاً 10 رقم بدون صفر وارد کنید">
                <input type="text" name="mobile_phone_4" placeholder="شماره تماس چهارم" class="input" maxlength="10" inputmode="numeric" pattern="[1-9][0-9]{9}" title="لطفاً 10 رقم بدون صفر وارد کنید">
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                <input type="text" name="city" placeholder="شهر" class="input">
                <input type="text" name="job_title" placeholder="شغل" class="input">
            </div>
            <div id="lead-activity-section" class="space-y-3 hidden">
            <!-- Duplicate City/Job fields removed. Use main fields. -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                    <input type="text" name="activity_job_desc" id="lead-activity-job-desc" placeholder="شرح شغل" class="input">
                    <input type="text" name="activity_extra_info" id="lead-activity-extra-info" placeholder="اطلاعات تکمیلی" class="input">
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                    <div>
                        <label class="text-xs text-gray-400 mb-1 block">مدت آشنایی</label>
                        <div class="flex flex-wrap items-center gap-2">
                            <select id="lead-activity-acq-years" name="activity_acq_years" class="input bg-gray-800 w-24">
                                <?php for($i=0;$i<=10;$i++): ?>
                                <option value="<?php echo $i; ?>"><?php echo $i; ?> سال</option>
                                <?php endfor; ?>
                            </select>
                            <select id="lead-activity-acq-months" name="activity_acq_months" class="input bg-gray-800 w-24">
                                <?php for($i=0;$i<=11;$i++): ?>
                                <option value="<?php echo $i; ?>"><?php echo $i; ?> ماه</option>
                                <?php endfor; ?>
                            </select>
                            <label class="flex items-center gap-1 text-xs text-gray-300">
                                <input type="checkbox" id="lead-activity-acq-less" name="activity_acq_less" class="w-4 h-4">
                                <span>کمتر از ۱ ماه</span>
                            </label>
                        </div>
                    </div>
                    <div>
                        <label class="text-xs text-gray-400 mb-1 block">سطح مالی</label>
                        <select id="lead-activity-financial-level" name="activity_financial_level" class="input bg-gray-800">
                            <option value="">-- انتخاب سطح مالی --</option>
                            <option value="high">بالا</option>
                            <option value="medium_high">متوسط رو به بالا</option>
                            <option value="medium_low">متوسط رو به پایین</option>
                            <option value="low">پایین</option>
                        </select>
                    </div>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-3">
                    <div>
                        <label class="text-xs text-gray-400 mb-1 block">تخمین دارایی</label>
                        <select id="lead-activity-asset" name="activity_asset" class="input bg-gray-800">
                            <option value="">-- انتخاب بازه دارایی --</option>
                            <option value="0-50">0 تا 50 میلیون تومان</option>
                            <option value="50-200">50 تا 200 میلیون تومان</option>
                            <option value="200-500">200 تا 500 میلیون تومان</option>
                            <option value="500-1000">500 تا 1000 میلیون تومان</option>
                            <option value="1000-plus">بیش از 1 میلیارد تومان</option>
                        </select>
                    </div>
                    <div>
                        <label class="text-xs text-gray-400 mb-1 block">تخمین درآمد</label>
                        <select id="lead-activity-income" name="activity_income" class="input bg-gray-800">
                            <option value="">-- انتخاب بازه درآمد --</option>
                            <option value="0-20">0 تا 20 میلیون تومان</option>
                            <option value="20-100">20 تا 100 میلیون تومان</option>
                            <option value="100-200">100 تا 200 میلیون تومان</option>
                            <option value="200-500">200 تا 500 میلیون تومان</option>
                            <option value="500-plus">بیش از 500 میلیون تومان</option>
                        </select>
                    </div>
                    <div>
                        <label class="text-xs text-gray-400 mb-1 block">خرید با شماره دیگر</label>
                        <select id="lead-activity-has-purchase" name="activity_has_purchase" class="input bg-gray-800" onchange="app.handlePurchaseOtherNumberChange()">
                            <option value="">-- انتخاب کنید --</option>
                            <option value="1">بله</option>
                            <option value="0">خیر</option>
                        </select>
                        <div id="lead-previous-purchase-number-field" class="hidden mt-2">
                            <input type="text" id="lead-activity-previous-number" name="activity_previous_number" class="input" placeholder="شماره خرید قبلی" maxlength="10" inputmode="numeric" pattern="[1-9][0-9]{9}">
                        </div>
                    </div>
                </div>
            </div>
            <div id="lead-admin-fields" class="grid grid-cols-1 md:grid-cols-3 gap-3">
                <select name="acquaintance_source" id="lead-source" class="input bg-gray-800" onchange="app.handleSourceChange()">
                    <option value="">شیوه آشنایی</option>
                </select>
                <select name="acquaintance_detail" id="lead-source-detail" class="input bg-gray-800">
                    <option value="">جزئیات شیوه آشنایی</option>
                </select>
                <select name="content_topic" id="lead-content-topic" class="input bg-gray-800">
                    <option value="">موضوع محتوا</option>
                </select>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                <div>
                    <label class="text-xs text-gray-400 mb-1 block">سطح مشتری</label>
                    <select name="customer_level" id="lead-customer-level" class="input bg-gray-800">
                        <option value="">-- انتخاب سطح --</option>
                        <option value="طلایی">طلایی</option>
                        <option value="نقره‌ای">نقره‌ای</option>
                        <option value="برنز">برنز</option>
                    </select>
                </div>
                <div>
                    <label class="text-xs text-gray-400 mb-1 block">توضیحات سطح مشتری</label>
                    <input type="text" name="customer_level_notes" id="lead-customer-level-notes" placeholder="توضیحات سطح مشتری" class="input">
                </div>
            </div>
            <textarea name="background_info" placeholder="یادداشت / توضیحات تکمیلی" class="input h-24 resize-none"></textarea>
            
            <!-- Duplicate phone warning and new request activity section -->
            <div id="duplicate-phone-warning" class="hidden bg-yellow-900/20 border border-yellow-700 rounded-lg p-4 space-y-3">
                <div class="flex items-start gap-2">
                    <i class="fa-solid fa-triangle-exclamation text-yellow-500 mt-1"></i>
                    <div class="flex-1">
                        <p class="text-yellow-400 font-semibold mb-1">این شماره قبلاً درخواست داده است</p>
                        <p class="text-gray-400 text-sm mb-3" id="duplicate-contact-info"></p>
                        <div class="bg-gray-900/50 rounded p-3 space-y-2">
                            <label class="text-xs text-gray-400 block">ثبت فعالیت درخواست جدید</label>
                            <textarea id="new-request-note" placeholder="توضیحات درخواست جدید (اختیاری)" class="input h-20 resize-none text-sm"></textarea>
                            <button type="button" onclick="app.createNewRequestActivity()" class="btn-primary px-4 py-2 rounded text-sm w-full">
                                <i class="fa-solid fa-plus ml-2"></i>
                                ثبت فعالیت درخواست جدید
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            
	            <div class="flex justify-end gap-3">
	                <?php if(isAdmin()): ?>
	                <button type="button" id="lead-delete-btn" class="px-4 py-2 rounded-lg bg-red-600/80 hover:bg-red-600 text-white" onclick="app.deleteLeadFromLeadModal()">
	                    <i class="fa-solid fa-trash ml-1"></i> حذف لید
	                </button>
	                <?php endif; ?>
	                <button type="button" class="px-4 py-2 rounded-lg border border-gray-700 text-gray-400 hover:text-white" onclick="app.closeModal('modalLead')">انصراف</button>
	                <button type="submit" class="btn-primary px-6 py-2 rounded-lg">ثبت لید</button>
	            </div>
	        </form>
	    </div>
	</div>

<!-- Edit Scheduled Activity Modal -->
<div id="modalEditScheduledActivity" class="fixed inset-0 bg-black/80 hidden z-50 flex items-center justify-center p-4 backdrop-blur-sm">
    <div class="glass w-full max-w-lg md:max-w-2xl p-6 max-h-[90vh] overflow-y-auto">
        <div class="flex justify-between items-center mb-4">
            <h3 class="font-bold text-white text-lg">ویرایش فعالیت برنامه‌ریزی شده</h3>
            <button onclick="app.closeModal('modalEditScheduledActivity')" class="text-gray-500 hover:text-white"><i class="fa-solid fa-times"></i></button>
        </div>
        <form onsubmit="app.updateScheduledActivity(event)" class="space-y-4" id="edit-scheduled-activity-form">
            <input type="hidden" name="activity_id" id="edit-activity-id">
            <input type="hidden" name="contact_id" id="edit-activity-contact-id">
            
            <div>
                <label class="text-xs text-gray-400 mb-1 block">نوع فعالیت <span class="text-red-500">*</span></label>
                <select name="activity_type_id" id="edit-activity-type-id" class="input bg-gray-800" required>
                    <option value="">-- انتخاب نوع فعالیت --</option>
                </select>
            </div>
            
            <div class="bg-gradient-to-br from-blue-900/30 to-purple-900/30 p-4 rounded-lg border border-blue-500/20">
                <label class="text-sm text-gray-200 mb-3 block font-semibold flex items-center gap-2">
                    <i class="fa-solid fa-calendar-days text-blue-400"></i>
                    <span>تاریخ و زمان انجام فعالیت</span>
                </label>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                    <div>
                        <label class="text-xs text-gray-400 mb-2 block">تاریخ</label>
                        <div class="relative">
                            <input type="text" name="due_date" id="edit-activity-due-date" class="input bg-gray-800/80 border-blue-500/30 focus:border-blue-500 focus:ring-2 focus:ring-blue-500/20" placeholder="انتخاب تاریخ" readonly>
                            <i class="fa-solid fa-calendar absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 pointer-events-none"></i>
                        </div>
                        <input type="hidden" id="edit-activity-due-date-gregorian" name="due_date_gregorian">
                    </div>
                    <div>
                        <label class="text-xs text-gray-400 mb-2 block">ساعت</label>
                        <div class="flex gap-2">
                            <select id="edit-activity-due-hour" class="input bg-gray-800/80 border-blue-500/30 focus:border-blue-500 focus:ring-2 focus:ring-blue-500/20 text-center">
                                <option value="">ساعت</option>
                            </select>
                            <span class="text-gray-400 self-center">:</span>
                            <select id="edit-activity-due-minute" class="input bg-gray-800/80 border-blue-500/30 focus:border-blue-500 focus:ring-2 focus:ring-blue-500/20 text-center">
                                <option value="">دقیقه</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
            
            <label class="flex items-center gap-2 text-sm text-gray-300">
                <input type="checkbox" name="reminder_enabled" id="edit-activity-reminder-enabled" class="w-4 h-4" onchange="app.toggleEditActivityReminderFields()">
                <span>فعال کردن یادآوری</span>
            </label>
            
            <div id="edit-activity-reminder-fields" class="hidden">
                <label class="text-xs text-gray-400 mb-1 block">زمان یادآوری</label>
                <div class="grid grid-cols-2 gap-2">
                    <div>
                        <label class="text-xs text-gray-500 mb-1 block">ساعت قبل</label>
                        <select name="reminder_offset_hours" id="edit-activity-reminder-hours" class="input bg-gray-800 text-sm">
                            <option value="0">0 ساعت</option>
                            <option value="1">1 ساعت</option>
                            <option value="2">2 ساعت</option>
                            <option value="4">4 ساعت</option>
                            <option value="8">8 ساعت</option>
                            <option value="12">12 ساعت</option>
                            <option value="24" selected>1 روز</option>
                            <option value="48">2 روز</option>
                            <option value="72">3 روز</option>
                            <option value="168">1 هفته</option>
                        </select>
                    </div>
                    <div>
                        <label class="text-xs text-gray-500 mb-1 block">دقیقه قبل</label>
                        <select name="reminder_offset_minutes" id="edit-activity-reminder-minutes" class="input bg-gray-800 text-sm">
                            <option value="0" selected>0 دقیقه</option>
                            <option value="5">5 دقیقه</option>
                            <option value="10">10 دقیقه</option>
                            <option value="15">15 دقیقه</option>
                            <option value="30">30 دقیقه</option>
                        </select>
                    </div>
                </div>
                <input type="hidden" name="reminder_offset_minutes" id="edit-reminder-offset-total">
            </div>
            
            <div class="flex gap-3">
                <button type="submit" class="btn-primary flex-1 py-2.5 rounded-lg">
                    <i class="fa-solid fa-save ml-1"></i> ذخیره تغییرات
                </button>
                <button type="button" onclick="app.closeModal('modalEditScheduledActivity')" class="bg-gray-700 hover:bg-gray-600 text-white px-6 py-2.5 rounded-lg transition">
                    انصراف
                </button>
            </div>
        </form>
    </div>
</div>

<!-- IMPORT LEADS MODAL -->
<div id="importLeadsModal" class="hidden fixed inset-0 bg-black/50 z-50 flex items-center justify-center p-4">
    <div class="bg-gray-800 rounded-lg shadow-2xl max-w-2xl w-full max-h-[90vh] overflow-y-auto border border-gray-700">
        <div class="sticky top-0 p-6 border-b border-gray-700 bg-gray-800">
            <div class="flex justify-between items-center">
                <h2 class="text-xl font-bold text-white">وارد کردن لیدها از فایل اکسل</h2>
                <button onclick="app.closeModal('importLeadsModal')" class="text-gray-400 hover:text-white">
                    <i class="fa-solid fa-times text-xl"></i>
                </button>
            </div>
        </div>

        <div class="p-6 space-y-4">
            <!-- مرحله 1: انتخاب فایل -->
            <div id="import-step-1" class="space-y-4">
                <div class="bg-blue-900/20 border border-blue-600 rounded p-4 text-sm text-blue-200">
                    <p><strong>ستون‌های الزامی فایل اکسل:</strong></p>
                    <ul class="list-disc list-inside mt-2 space-y-1 text-xs">
                        <li>شماره لید (9 رقمی)</li>
                        <li>نام مسئول</li>
                        <li>شیوه آشنایی</li>
                        <li>جزئیات شیوه آشنایی</li>
                        <li>موضوع محتوا</li>
                    </ul>
                </div>

                <div class="border-2 border-dashed border-gray-600 rounded p-6 text-center hover:border-yellow-500 transition cursor-pointer" onclick="document.getElementById('import-file-input').click()">
                    <input type="file" id="import-file-input" accept=".xlsx,.xls,.csv" class="hidden" onchange="app.handleImportFileSelect(event)">
                    <div class="text-gray-400 hover:text-white">
                        <i class="fa-solid fa-cloud-arrow-up text-3xl mb-2 block"></i>
                        <p class="text-sm font-semibold">فایل خود را اینجا رها کنید یا کلیک کنید</p>
                        <p class="text-xs text-gray-500 mt-1">Excel یا CSV (حداکثر 5 مگابایت)</p>
                    </div>
                </div>

                <div id="import-file-selected" class="hidden bg-green-900/20 border border-green-600 rounded p-3 text-sm text-green-300">
                    <i class="fa-solid fa-check-circle ml-2"></i>
                    <span id="import-file-name"></span>
                </div>
            </div>

            <!-- مرحله 2: Preview -->
            <div id="import-step-2" class="hidden space-y-4">
                <div class="bg-blue-900/20 border border-blue-600 rounded p-4">
                    <p class="text-sm">
                        <strong class="text-blue-300">ردیف‌های معتبر:</strong> <span id="import-preview-success" class="text-green-400 font-bold">0</span> | 
                        <strong class="text-blue-300">ردیف‌های با خطا:</strong> <span id="import-preview-error" class="text-red-400 font-bold">0</span>
                    </p>
                </div>

                <div class="max-h-64 overflow-y-auto border border-gray-700 rounded">
                    <table class="w-full text-xs border-collapse">
                        <thead class="sticky top-0 bg-gray-700">
                            <tr>
                                <th class="border border-gray-600 p-2 text-right">ردیف</th>
                                <th class="border border-gray-600 p-2 text-right">شماره</th>
                                <th class="border border-gray-600 p-2 text-right">مسئول</th>
                                <th class="border border-gray-600 p-2 text-right">وضعیت</th>
                            </tr>
                        </thead>
                        <tbody id="import-preview-table" class="bg-gray-900">
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- مرحله 3: نتایج -->
            <div id="import-step-3" class="hidden space-y-4">
                <div class="grid grid-cols-2 gap-4">
                    <div class="bg-green-900/20 border border-green-600 rounded p-4">
                        <p class="text-xs text-gray-400">لیدهای موفق</p>
                        <p class="text-2xl font-bold text-green-400" id="import-result-success">0</p>
                    </div>
                    <div class="bg-red-900/20 border border-red-600 rounded p-4">
                        <p class="text-xs text-gray-400">لیدهای ناموفق</p>
                        <p class="text-2xl font-bold text-red-400" id="import-result-error">0</p>
                    </div>
                </div>

                <div class="max-h-48 overflow-y-auto border border-gray-700 rounded p-3 bg-gray-900">
                    <div id="import-result-table" class="text-xs space-y-2"></div>
                </div>
            </div>
        </div>

        <!-- دکمه‌ها -->
        <div class="sticky bottom-0 p-4 border-t border-gray-700 bg-gray-800 flex gap-2 justify-end">
            <button onclick="app.closeModal('importLeadsModal')" class="px-4 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded transition">
                بستن
            </button>
            <button id="import-btn-preview" onclick="app.previewImportLeads()" class="hidden px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded transition">
                <i class="fa-solid fa-eye ml-1"></i> مشاهده پیش‌نمایش
            </button>
            <button id="import-btn-execute" onclick="app.executeImportLeads()" class="hidden px-4 py-2 bg-green-600 hover:bg-green-700 text-white rounded transition">
                <i class="fa-solid fa-check-circle ml-1"></i> انجام ایمپورت
            </button>
            <button id="import-btn-done" onclick="app.closeModal('importLeadsModal'); app.loadLeads(1);" class="hidden px-4 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded transition">
                بازگشت به لیدها
            </button>
        </div>
    </div>
</div>

<!-- KPI Dashboard Modal -->
<div id="modalKPI" class="hidden fixed inset-0 bg-black/80 z-50 flex items-center justify-center p-4 backdrop-blur-sm overflow-y-auto">
    <div class="glass w-full max-w-7xl mx-auto p-6 my-8 max-h-screen overflow-y-auto">
        <div class="flex justify-between items-center mb-6">
            <h2 class="text-2xl font-bold text-yellow-500">داشبورد KPI مالی</h2>
            <button onclick="app.closeModal('modalKPI')" class="text-gray-400 hover:text-white">
                <i class="fa-solid fa-times text-2xl"></i>
            </button>
        </div>
        <div id="kpi-dashboard-content">
            <!-- KPI content will be loaded here -->
        </div>
    </div>
</div>
