<!-- 0. DASHBOARD VIEW -->
<div id="view-dashboard" class="view-section h-full p-6 flex flex-col overflow-y-auto">
    <?php if(isAdmin()): ?>
    <div id="dashboard-filters" class="mb-6 flex gap-3 flex-wrap items-end bg-gray-800/40 p-4 rounded-xl border border-gray-700/50 backdrop-blur-sm shadow-lg">
        <div class="flex flex-col gap-1.5">
            <label class="text-[11px] font-bold text-gray-400 mr-1 flex items-center gap-1">
                <i class="fa-solid fa-user-tie text-blue-400"></i> فیلتر مسئول
            </label>
            <select id="dashboard-owner-filter" class="input bg-gray-900 border-gray-700 text-sm w-full md:w-64 focus:ring-blue-500/50" onchange="app.loadDashboard()">
                <option value="">همه مسئول‌ها (کل سیستم)</option>
            </select>
        </div>
        <div class="flex flex-col gap-1.5">
            <label class="text-[11px] font-bold text-gray-400 mr-1 flex items-center gap-1">
                <i class="fa-solid fa-circle-info text-yellow-400"></i> وضعیت معاملات
            </label>
            <select id="dashboard-status-filter" class="input bg-gray-900 border-gray-700 text-sm w-full md:w-48 focus:ring-yellow-500/50" onchange="app.loadDashboard()">
                <option value="all">همه وضعیت‌ها</option>
                <option value="Pending">جاری (در جریان)</option>
                <option value="Won">موفق (برنده شده)</option>
                <option value="Lost">ناموفق (باخته شده)</option>
            </select>
        </div>
        <button onclick="app.loadDashboard()" class="btn-primary h-[42px] px-6 rounded-lg text-sm transition-all hover:bg-blue-600 flex items-center gap-2">
            <i class="fa-solid fa-arrows-rotate"></i> بروزرسانی داشبورد
        </button>
    </div>
    <?php endif; ?>
    <div id="dashboard-content"></div>
</div>

<!-- 1. LEADS VIEW -->
<div id="view-leads" class="view-section h-full p-6 hidden flex flex-col">
		    <div class="mb-4 flex gap-3 flex-wrap">
		        <div class="flex gap-2 w-full md:w-auto">
		            <input type="text" id="leads-search" placeholder="جستجو..." class="input flex-1 md:w-72 lg:w-80" onkeypress="if(event.key==='Enter') app.loadLeads(1)">
		            <button type="button" onclick="app.loadLeads(1)" class="btn-primary px-4 py-2 rounded text-sm whitespace-nowrap">
		                <i class="fa-solid fa-magnifying-glass ml-1"></i> جستجو
		            </button>
		        </div>
		        <button type="button" onclick="app.openLocalMobileLookup()" class="btn-primary px-4 py-2 rounded text-sm">
		            <i class="fa-solid fa-mobile-screen ml-1"></i> استعلام سریع شماره
		        </button>
	        <?php if(isAdmin()): ?>
	        <button onclick="app.openDidarSearchModal()" class="btn-primary px-4 py-2 rounded text-sm">
	            <i class="fa-solid fa-search ml-1"></i> جستجو در دیدار
	        </button>
	        <?php endif; ?>
	        <select id="leads-stage-filter" class="input bg-gray-800 w-full md:w-48">
	            <option value="all">همه لیدها</option>
	            <option value="success">موفق</option>
	            <option value="failed">ناموفق</option>
	        </select>
	        <?php if(isAdminOrCrmSpecialist()): ?>
	        <select id="leads-owner-filter" class="input bg-gray-800 w-full md:w-56" onchange="app.loadLeads(1)">
	            <option value="">همه مسئول‌ها</option>
	        </select>
	        <?php endif; ?>
	        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-2 flex-1 min-w-[240px]">
            <div class="flex gap-2">
                <input type="text" id="leads-register-from" class="input w-full" placeholder="از تاریخ ثبت" onkeypress="if(event.key==='Enter') app.loadLeads(1)">
                <input type="text" id="leads-register-to" class="input w-full" placeholder="تا تاریخ ثبت" onkeypress="if(event.key==='Enter') app.loadLeads(1)">
                    </div>
            <div class="flex gap-2">
                <input type="text" id="leads-activity-from" class="input w-full" placeholder="از تاریخ فعالیت" onkeypress="if(event.key==='Enter') app.loadLeads(1)">
                <input type="text" id="leads-activity-to" class="input w-full" placeholder="تا تاریخ فعالیت" onkeypress="if(event.key==='Enter') app.loadLeads(1)">
            </div>
            <select id="leads-product-filter" class="input bg-gray-800 w-full">
                <option value="">محصول / خدمت</option>
            </select>
            <select id="leads-customer-level-filter" class="input bg-gray-800 w-full">
                <option value="">سطح مشتری</option>
                <option value="طلایی">طلایی</option>
                <option value="نقره‌ای">نقره‌ای</option>
                <option value="برنز">برنز</option>
            </select>
        </div>
	        <?php if(isAdmin()): ?>
	        <button type="button" onclick="app.openLeadModal()" class="btn-primary px-4 py-2 rounded text-sm flex items-center gap-2">
	            <i class="fa-solid fa-user-plus"></i>
	            ثبت لید جدید
	        </button>
	        <button type="button" onclick="app.openImportLeadsModal()" class="btn-primary px-4 py-2 rounded text-sm flex items-center gap-2">
	            <i class="fa-solid fa-file-import"></i>
	            ایمپورت از اکسل
	        </button>
	        <?php endif; ?>
        <button onclick="app.loadLeads(1)" class="btn-primary px-6 rounded-lg">فیلتر</button>
    </div>
<div class="flex-1 overflow-y-auto pb-24">
        <div id="leads-list" class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-4"></div>
        <div id="leads-pagination"></div>
    </div>
</div>

<!-- 1.1 BLATAKLIF LEADS VIEW -->
<div id="view-blataklif-leads" class="view-section h-full p-6 hidden flex flex-col">
    <div class="mb-4 flex gap-3 flex-wrap">
        <input type="text" id="blataklif-leads-search" placeholder="جستجو..." class="input w-full md:w-72 lg:w-80" onkeypress="if(event.key==='Enter') app.loadBlataklifLeads(1)">
        <select id="blataklif-leads-sale-status-filter" class="input bg-gray-800 w-full md:w-48">
            <option value="all">همه</option>
            <option value="success">موفق</option>
            <option value="failed">ناموفق</option>
        </select>
        <button onclick="app.loadBlataklifLeads(1)" class="btn-primary px-6 rounded-lg">فیلتر</button>
        <div class="text-xs text-gray-400 flex items-center gap-2">
            <span class="px-2 py-1 bg-gray-800 rounded">این لیست از «لیدها» جداست</span>
        </div>
    </div>
    <div class="flex-1 overflow-y-auto pb-24">
        <div id="blataklif-leads-list" class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-4"></div>
        <div id="blataklif-leads-pagination"></div>
    </div>
</div>

<!-- 2. DEALS VIEW -->
<div id="view-deals" class="view-section h-full p-6 hidden flex flex-col">
    <div class="glass flex-1 overflow-hidden flex flex-col">
        <div class="p-4 border-b border-gray-700/50 flex flex-col gap-4">
            <div class="flex justify-between items-center">
                <h3 class="font-bold text-yellow-500 text-lg flex items-center gap-2">
                    <i class="fa-solid fa-sack-dollar text-xl"></i>
                    لیست معاملات
                </h3>
                <span class="text-[10px] text-gray-500 bg-gray-800/50 px-2.5 py-1 rounded-full border border-gray-700/30">
                    <i class="fa-solid fa-cloud-arrow-down ml-1"></i>
                    مستقیم از دیدار
                </span>
            </div>
            
            <!-- Horizontal Filter Bar -->
            <div class="flex flex-wrap gap-3 items-center bg-gray-900/30 p-3 rounded-2xl border border-gray-800/50">
                <!-- Search -->
                <div class="relative flex-1 min-w-[200px]">
                    <i class="fa-solid fa-search absolute right-3 top-1/2 -translate-y-1/2 text-gray-500 text-xs"></i>
                    <input type="text" id="deals-search" placeholder="جستجوی معامله یا مشتری..." 
                        class="input bg-gray-800/50 border-gray-700/50 pr-9 text-xs w-full focus:ring-yellow-500/30"
                        onkeypress="if(event.key==='Enter') app.loadDeals()">
                </div>

                <!-- Status Filter -->
                <div class="flex flex-col gap-1">
                    <select id="deals-status-filter" class="input bg-gray-800/50 border-gray-700/50 text-[11px] h-9 min-w-[120px] focus:ring-yellow-500/30" onchange="app.loadDeals()">
                        <option value="all">همه وضعیت‌ها</option>
                        <option value="pending">جاری</option>
                        <option value="won">موفق</option>
                        <option value="lost">ناموفق</option>
                    </select>
                </div>

                <!-- Stage Filter -->
                <div class="flex flex-col gap-1">
                    <select id="deals-pipeline-filter" class="input bg-gray-800/50 border-gray-700/50 text-[11px] h-9 min-w-[140px] focus:ring-yellow-500/30" onchange="app.loadDeals()">
                        <option value="all">همه مراحل کاریز</option>
                        <option value="بلاتکلیف">بلاتکلیف</option>
                        <option value="معامله جدید">معامله جدید</option>
                        <option value="تماس عدم پاسخ">تماس عدم پاسخ</option>
                        <option value="تماس پیگیری">تماس پیگیری</option>
                        <option value="ارسال لینک پرداخت">ارسال لینک پرداخت</option>
                        <option value="پرداخت">پرداخت</option>
                        <option value="پیگیری مانده حساب">پیگیری مانده حساب</option>
                        <option value="برگزاری دوره">برگزاری دوره</option>
                        <option value="پشتیبانی">پشتیبانی</option>
                        <option value="ارجاع به CRM">ارجاع به CRM</option>
                    </select>
                </div>

                <!-- Owner Filter (Admin only) -->
                <?php if(isAdminOrCrmSpecialist()): ?>
                <div class="flex flex-col gap-1">
                    <select id="deals-owner-filter" class="input bg-gray-800/50 border-gray-700/50 text-[11px] h-9 min-w-[140px] focus:ring-yellow-500/30" onchange="app.loadDeals()">
                        <option value="">همه مسئول‌ها</option>
                    </select>
                </div>
                <?php endif; ?>

                <!-- Refresh Button -->
                <button onclick="app.loadDeals()" class="btn-primary h-9 px-4 rounded-xl text-xs transition-all hover:scale-105 flex items-center gap-2">
                    <i class="fa-solid fa-arrows-rotate"></i>
                    بروزرسانی
                </button>
            </div>

            <!-- Quick Filter Chips -->
            <div class="flex gap-2 overflow-x-auto pb-1 no-scrollbar">
                <button onclick="app.setQuickStatusFilter('all')" class="quick-filter-chip active" data-status="all">همه</button>
                <button onclick="app.setQuickStatusFilter('pending')" class="quick-filter-chip" data-status="pending">جاری</button>
                <button onclick="app.setQuickStatusFilter('won')" class="quick-filter-chip" data-status="won">موفق</button>
                <button onclick="app.setQuickStatusFilter('lost')" class="quick-filter-chip" data-status="lost">ناموفق</button>
            </div>
        </div>
        <div class="overflow-y-auto p-4 pb-24">
            <div id="deals-container" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 2xl:grid-cols-5 gap-5"></div>
        </div>
    </div>
</div>

<!-- Legacy Deals View -->
<div id="view-legacy-deals" class="view-section h-full p-6 hidden flex flex-col">
    <div class="glass flex-1 overflow-hidden flex flex-col">
        <div class="p-4 border-b border-gray-700 flex flex-col gap-4">
            <div class="flex justify-between items-center">
                <h3 class="font-bold text-purple-400 text-lg flex items-center gap-2">
                    <i class="fa-solid fa-clock-rotate-left text-xl"></i>
                    معاملات گذشته دیدار
                </h3>
                <span class="text-[10px] text-gray-500 bg-gray-800/50 px-2.5 py-1 rounded-full border border-gray-700/30">
                    فقط معاملات ایمپورت شده
                </span>
            </div>
            <div class="flex flex-wrap gap-3 items-center bg-gray-900/30 p-3 rounded-2xl border border-gray-800/50">
                <div class="relative flex-1 min-w-[200px]">
                    <i class="fa-solid fa-search absolute right-3 top-1/2 -translate-y-1/2 text-gray-500 text-xs"></i>
                    <input type="text" id="legacy-deals-search" placeholder="جستجو در معاملات گذشته..."
                        class="input bg-gray-800/50 border-gray-700/50 pr-9 text-xs w-full focus:ring-yellow-500/30"
                        onkeypress="if(event.key==='Enter') app.loadLegacyDeals()">
                </div>

                <div class="flex flex-col gap-1">
                    <select id="legacy-deals-status-filter" class="input bg-gray-800/50 border-gray-700/50 text-[11px] h-9 min-w-[120px] focus:ring-yellow-500/30" onchange="app.loadLegacyDeals()">
                        <option value="all">همه وضعیت‌ها</option>
                        <option value="pending">در جریان</option>
                        <option value="won">موفق</option>
                        <option value="lost">ناموفق</option>
                    </select>
                </div>

                <?php if(isAdminOrCrmSpecialist()): ?>
                <div class="flex flex-col gap-1">
                    <select id="legacy-deals-owner-filter" class="input bg-gray-800/50 border-gray-700/50 text-[11px] h-9 min-w-[140px] focus:ring-yellow-500/30" onchange="app.loadLegacyDeals()">
                        <option value="">همه مسئول‌ها</option>
                    </select>
                </div>
                <?php endif; ?>

                <button onclick="app.loadLegacyDeals()" class="btn-primary h-9 px-4 rounded-xl text-xs transition-all hover:scale-105 flex items-center gap-2">
                    <i class="fa-solid fa-arrows-rotate"></i>
                    به‌روزرسانی
                </button>
            </div>
        </div>
        <div class="overflow-y-auto p-4 pb-24">
            <div id="legacy-deals-container" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 2xl:grid-cols-5 gap-5"></div>
            <div id="legacy-deals-pagination" class="flex justify-center mt-6">
                <button id="legacy-deals-load-more" onclick="app.loadMoreLegacyDeals()" class="btn-primary px-6 py-2 rounded-lg hidden">
                    نمایش بیشتر
                </button>
            </div>
        </div>
    </div>
</div>

<?php if(isAdminOrCrmSpecialist()): ?>
<!-- 3. REFERRALS VIEW -->
<div id="view-referrals" class="view-section h-full p-6 hidden flex flex-col">
    <div class="glass flex-1 overflow-hidden flex flex-col">
        <div class="p-4 border-b border-gray-700 flex justify-between items-center">
            <h3 class="font-bold text-pink-500">ارجاع‌های به CRM</h3>
            <button class="text-xs text-gray-400 hover:text-white" onclick="app.loadReferrals()"><i class="fa-solid fa-rotate-right ml-1"></i> بروزرسانی</button>
        </div>
        <div class="overflow-y-auto pb-24">
            <div class="overflow-x-auto">
                <table class="w-full text-sm text-right min-w-[800px]">
                    <thead class="bg-gray-800 text-gray-400 text-xs">
                        <tr>
                            <th class="p-3">لید</th>
                            <th class="p-3">شماره‌ها</th>
                            <th class="p-3">ارجاع‌دهنده</th>
                            <th class="p-3">تاریخ ارجاع</th>
                            <th class="p-3">توضیحات</th>
                        </tr>
                    </thead>
                    <tbody id="referrals-list" class="text-gray-300 text-xs"></tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- 4. SETTINGS VIEW -->
<div id="view-settings" class="view-section h-full p-6 hidden flex flex-col">
    <div class="glass p-6">
        <h3 class="font-bold text-white mb-6">تنظیمات</h3>
        
        <div class="space-y-6">
            <!-- Change Password Section -->
            <div class="border border-gray-700 rounded-lg p-6">
                <h4 class="text-lg font-bold text-yellow-500 mb-4">
                    <i class="fa-solid fa-key ml-2"></i> تغییر رمز عبور
                </h4>
                <form onsubmit="app.changePasswordFromSettings(event)" class="space-y-4">
                    <input type="hidden" name="user_id" id="settings-change-password-user-id" value="<?php echo $_SESSION['user_id'] ?? 0; ?>">
                    
                    <div>
                        <label class="text-sm text-gray-400 mb-1 block">رمز عبور فعلی</label>
                        <input type="password" name="current_password" id="settings-current-password" placeholder="رمز عبور فعلی" class="input" required>
                    </div>
                    
                    <div>
                        <label class="text-sm text-gray-400 mb-1 block">رمز عبور جدید</label>
                        <input type="password" name="new_password" id="settings-new-password" placeholder="رمز عبور جدید (حداقل 6 کاراکتر)" class="input" required minlength="6">
                    </div>
                    
                    <div>
                        <label class="text-sm text-gray-400 mb-1 block">تأیید رمز عبور جدید</label>
                        <input type="password" name="confirm_password" id="settings-confirm-password" placeholder="تأیید رمز عبور جدید" class="input" required minlength="6">
                    </div>
                    
                    <button type="submit" class="btn-primary w-full py-2 rounded-lg">
                        <i class="fa-solid fa-save ml-2"></i> تغییر رمز عبور
                    </button>
                </form>
            </div>
            
            <!-- User Info Section -->
            <div class="border border-gray-700 rounded-lg p-6">
                <h4 class="text-lg font-bold text-yellow-500 mb-4">
                    <i class="fa-solid fa-user ml-2"></i> اطلاعات کاربری
                </h4>
                <div class="space-y-3 text-sm">
                    <div class="flex justify-between">
                        <span class="text-gray-400">نام:</span>
                        <span class="text-white"><?php echo htmlspecialchars($_SESSION['name'] ?? ''); ?></span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-400">ایمیل:</span>
                        <span class="text-white"><?php echo htmlspecialchars($_SESSION['email'] ?? ''); ?></span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-400">نقش:</span>
                        <span class="text-white"><?php 
                            $role = $_SESSION['role'] ?? '';
                            echo $role === 'admin' ? 'مدیر' : ($role === 'crm_specialist' ? 'کارشناس CRM' : 'کارشناس');
                        ?></span>
                    </div>
                </div>
            </div>
            <?php if(isAdmin()): ?>
            <div class="border border-gray-700 rounded-lg p-6">
                <h4 class="text-lg font-bold text-yellow-500 mb-4">
                    <i class="fa-solid fa-cloud-arrow-up ml-2"></i> تنظیمات ارسال به دیدار
                </h4>
                <p class="text-xs text-gray-400 mb-4">در صورت غیرفعال بودن، لید و فعالیت جدید فقط در سیستم ثبت می‌شود و به دیدار ارسال نمی‌شود.</p>
                <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-3">
                    <label class="flex items-center gap-2 text-sm">
                        <input type="checkbox" id="settings-didar-write-enabled" class="accent-yellow-500">
                        <span>ارسال لید و فعالیت جدید به دیدار</span>
                    </label>
                    <button type="button" onclick="app.saveDidarWriteSettings()" class="btn-primary px-4 py-2 rounded text-xs">ذخیره</button>
                </div>
                <p class="text-xs text-gray-500 mt-2" id="settings-didar-write-status"></p>
            </div>
            <?php endif; ?>
        </div>
            
    </div>
</div>

<?php if(isAdmin()): ?>
<!-- 4.4 LOOKUPS VIEW (ADMIN) -->
<div id="view-lookups" class="view-section h-full p-6 hidden flex flex-col overflow-y-auto pb-24">
    <!-- Tabs -->
    <div class="flex gap-3 mb-4 border-b border-gray-700">
        <button onclick="app.switchLookupTab('groups')" class="lookup-tab px-4 py-2 text-sm text-gray-400 hover:text-white border-b-2 border-transparent active" data-tab="groups">
            <i class="fa-solid fa-list ml-1"></i> Lookup Groups
        </button>
        <button onclick="app.switchLookupTab('fields')" class="lookup-tab px-4 py-2 text-sm text-gray-400 hover:text-white border-b-2 border-transparent" data-tab="fields">
            <i class="fa-solid fa-sliders ml-1"></i> Field Configurations
        </button>
    </div>

    <!-- Field Configurations Tab (Removed separate tab, merged into groups) -->
    <div id="lookup-groups-tab" class="lookup-tab-content glass p-6">
        <div class="flex justify-between items-center mb-4">
            <h3 class="font-bold text-white">مدیریت لوکاپ‌ها و فیلدها</h3>
            <button onclick="app.loadLookupAdmin(true)" class="text-xs text-gray-400 hover:text-white">
                <i class="fa-solid fa-rotate-right ml-1"></i> بروزرسانی
            </button>
        </div>
        
        <div class="grid grid-cols-1 gap-6 mb-6">
            <div class="bg-gray-900/40 p-4 rounded-xl border border-gray-800">
                <label class="block text-xs font-bold text-blue-400 mb-2 uppercase tracking-wider">انتخاب فیلد یا گروه جهت تنظیمات</label>
                <select id="lookup-group-select" class="input bg-gray-800 w-full border-gray-700 focus:ring-blue-500/50" onchange="app.onLookupGroupChange()">
                    <option value="">-- انتخاب کنید --</option>
                </select>
            </div>
        </div>

        <!-- Field Configuration Settings Panel -->
        <div id="field-advanced-settings" class="hidden bg-gray-800/40 p-5 rounded-xl border border-gray-700/50 mb-6">
            <h4 class="text-sm font-bold text-blue-400 mb-4 flex items-center gap-2">
                <i class="fa-solid fa-sliders"></i> تنظیمات فیلد
            </h4>
            
            <!-- Row 1: Basic Settings -->
            <div class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-6 gap-4 mb-4">
                <label class="flex items-center gap-2 text-xs text-gray-400 cursor-pointer group bg-gray-900/40 p-3 rounded-lg border border-gray-700/50 hover:border-blue-500/50 transition-colors">
                    <input type="checkbox" id="fc-is-required" onchange="app.saveFieldConfigurationMerged()" class="w-4 h-4 rounded border-gray-600 bg-gray-900 text-blue-600">
                    <span class="group-hover:text-white">اجباری</span>
                    <i class="fa-solid fa-circle-info text-gray-600 text-[10px]" title="این فیلد برای ثبت الزامی است"></i>
                </label>
                <label class="flex items-center gap-2 text-xs text-gray-400 cursor-pointer group bg-gray-900/40 p-3 rounded-lg border border-gray-700/50 hover:border-blue-500/50 transition-colors">
                    <input type="checkbox" id="fc-is-editable" onchange="app.saveFieldConfigurationMerged()" class="w-4 h-4 rounded border-gray-600 bg-gray-900 text-blue-600" checked>
                    <span class="group-hover:text-white">قابل ویرایش</span>
                    <i class="fa-solid fa-circle-info text-gray-600 text-[10px]" title="کاربران مجاز می‌توانند این فیلد را ویرایش کنند"></i>
                </label>
                <label class="flex items-center gap-2 text-xs text-gray-400 cursor-pointer group bg-gray-900/40 p-3 rounded-lg border border-gray-700/50 hover:border-blue-500/50 transition-colors">
                    <input type="checkbox" id="fc-is-editable-after-create" onchange="app.saveFieldConfigurationMerged()" class="w-4 h-4 rounded border-gray-600 bg-gray-900 text-blue-600" checked>
                    <span class="group-hover:text-white">ویرایش پس از ثبت</span>
                    <i class="fa-solid fa-circle-info text-gray-600 text-[10px]" title="آیا پس از اولین ثبت قابل ویرایش است؟"></i>
                </label>
                <label class="flex items-center gap-2 text-xs text-gray-400 cursor-pointer group bg-gray-900/40 p-3 rounded-lg border border-gray-700/50 hover:border-blue-500/50 transition-colors">
                    <input type="checkbox" id="fc-is-active" onchange="app.saveFieldConfigurationMerged()" class="w-4 h-4 rounded border-gray-600 bg-gray-900 text-blue-600" checked>
                    <span class="group-hover:text-white">فعال</span>
                    <i class="fa-solid fa-circle-info text-gray-600 text-[10px]" title="اگر غیرفعال شود، این فیلد نمایش داده نمی‌شود"></i>
                </label>
            </div>

            <!-- Row 2: Role Permissions -->
            <div class="bg-gray-900/40 p-4 rounded-lg border border-gray-700/50 mb-4">
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div>
                        <label class="block text-[10px] text-gray-500 uppercase font-bold mb-2">دسترسی ویرایش:</label>
                        <div class="flex flex-wrap items-center gap-3" id="fc-roles-container">
                            <label class="flex items-center gap-1 text-[11px] text-gray-400 cursor-pointer hover:text-white">
                                <input type="checkbox" value="admin" onchange="app.saveFieldConfigurationMerged()" class="role-checkbox w-3 h-3 rounded"> مدیر
                            </label>
                            <label class="flex items-center gap-1 text-[11px] text-gray-400 cursor-pointer hover:text-white">
                                <input type="checkbox" value="crm_specialist" onchange="app.saveFieldConfigurationMerged()" class="role-checkbox w-3 h-3 rounded"> CRM
                            </label>
                            <label class="flex items-center gap-1 text-[11px] text-gray-400 cursor-pointer hover:text-white">
                                <input type="checkbox" value="agent" onchange="app.saveFieldConfigurationMerged()" class="role-checkbox w-3 h-3 rounded"> کارشناس
                            </label>
                        </div>
                    </div>
                    <div>
                        <label class="block text-[10px] text-gray-500 uppercase font-bold mb-2">دسترسی حذف:</label>
                        <div class="flex flex-wrap items-center gap-3" id="fc-delete-roles-container">
                            <label class="flex items-center gap-1 text-[11px] text-gray-400 cursor-pointer hover:text-white">
                                <input type="checkbox" value="admin" onchange="app.saveFieldConfigurationMerged()" class="delete-role-checkbox w-3 h-3 rounded"> مدیر
                            </label>
                            <label class="flex items-center gap-1 text-[11px] text-gray-400 cursor-pointer hover:text-white">
                                <input type="checkbox" value="crm_specialist" onchange="app.saveFieldConfigurationMerged()" class="delete-role-checkbox w-3 h-3 rounded"> CRM
                            </label>
                            <label class="flex items-center gap-1 text-[11px] text-gray-400 cursor-pointer hover:text-white">
                                <input type="checkbox" value="agent" onchange="app.saveFieldConfigurationMerged()" class="delete-role-checkbox w-3 h-3 rounded"> کارشناس
                            </label>
                        </div>
                    </div>
                    <div>
                        <label class="block text-[10px] text-gray-500 uppercase font-bold mb-2">نقش‌های مشاهده:</label>
                        <div class="flex flex-wrap items-center gap-3" id="fc-view-roles-container">
                            <label class="flex items-center gap-1 text-[11px] text-gray-400 cursor-pointer hover:text-white">
                                <input type="checkbox" value="admin" onchange="app.saveFieldConfigurationMerged()" class="view-role-checkbox w-3 h-3 rounded"> مدیر
                            </label>
                            <label class="flex items-center gap-1 text-[11px] text-gray-400 cursor-pointer hover:text-white">
                                <input type="checkbox" value="crm_specialist" onchange="app.saveFieldConfigurationMerged()" class="view-role-checkbox w-3 h-3 rounded"> CRM
                            </label>
                            <label class="flex items-center gap-1 text-[11px] text-gray-400 cursor-pointer hover:text-white">
                                <input type="checkbox" value="agent" onchange="app.saveFieldConfigurationMerged()" class="view-role-checkbox w-3 h-3 rounded"> کارشناس
                            </label>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Row 3: Advanced Settings -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4 mb-4">
                <div>
                    <label class="block text-[10px] text-gray-500 uppercase font-bold mb-1">برچسب فیلد (نمایش فارسی)</label>
                    <input type="text" id="fc-field-label" class="input bg-gray-900 text-xs w-full" placeholder="مثال: 4 رقم آخر کارت" onchange="app.saveFieldConfigurationMerged()">
                </div>
                <div>
                    <label class="block text-[10px] text-gray-500 uppercase font-bold mb-1">مقدار پیش‌فرض</label>
                    <input type="text" id="fc-default-value" class="input bg-gray-900 text-xs w-full" placeholder="مثال: card_reader" onchange="app.saveFieldConfigurationMerged()">
                </div>
                <div>
                    <label class="block text-[10px] text-gray-500 uppercase font-bold mb-1">گروه/تب</label>
                    <input type="text" id="fc-group-name" class="input bg-gray-900 text-xs w-full" placeholder="مثال: اطلاعات مالی" onchange="app.saveFieldConfigurationMerged()">
                </div>
            </div>

            <!-- Row 4: Validation & Help -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-4">
                <div>
                    <label class="block text-[10px] text-gray-500 uppercase font-bold mb-1">الگوی اعتبارسنجی (Regex)</label>
                    <input type="text" id="fc-validation-pattern" class="input bg-gray-900 text-xs w-full font-mono" placeholder="مثال: ^\d{4}$" onchange="app.saveFieldConfigurationMerged()">
                    <p class="text-[9px] text-gray-600 mt-1">فقط کاراکترهایی که با این الگو مطابقت دارند مجاز هستند</p>
                </div>
                <div>
                    <label class="block text-[10px] text-gray-500 uppercase font-bold mb-1">متن راهنما (Tooltip)</label>
                    <textarea id="fc-help-text" class="input bg-gray-900 text-xs w-full h-16 resize-none" placeholder="این متن به عنوان راهنما در کنار فیلد نمایش داده می‌شود..." onchange="app.saveFieldConfigurationMerged()"></textarea>
                </div>
            </div>

            <!-- Row 5: Conditional Logic -->
            <div class="bg-gray-900/40 p-4 rounded-lg border border-gray-700/50">
                <label class="block text-[10px] text-gray-500 uppercase font-bold mb-2">
                    <i class="fa-solid fa-code-branch text-yellow-500 ml-1"></i>
                    منطق شرطی (اختیاری)
                </label>
                <p class="text-[10px] text-gray-600 mb-2">این فیلد را فقط زمانی نمایش بده که شرط زیر برقرار باشد:</p>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-3">
                    <input type="text" id="fc-conditional-field" class="input bg-gray-800 text-xs" placeholder="نام فیلد وابسته (مثال: payment_method)">
                    <select id="fc-conditional-operator" class="input bg-gray-800 text-xs">
                        <option value="=">=  برابر</option>
                        <option value="!=">≠  نابرابر</option>
                        <option value="in">در لیست</option>
                        <option value="not_empty">پر باشد</option>
                        <option value="empty">خالی باشد</option>
                    </select>
                    <input type="text" id="fc-conditional-value" class="input bg-gray-800 text-xs" placeholder="مقدار (مثال: card_to_card)">
                </div>
                <input type="hidden" id="fc-conditional-logic">
                <button type="button" onclick="app.applyConditionalLogicFromUI()" class="text-[10px] text-blue-400 hover:text-blue-300 mt-2">
                    <i class="fa-solid fa-check ml-1"></i> اعمال شرط
                </button>
            </div>
        </div>

        <div id="lookup-items-section" class="hidden mt-6">
            <div class="flex flex-wrap items-center justify-between gap-4 mb-4 bg-gray-800/30 p-4 rounded-xl border border-gray-700/50">
                <div class="flex items-center gap-3">
                    <h4 class="text-sm font-bold text-gray-300 flex items-center gap-2">
                        <i class="fa-solid fa-list-ul text-blue-400"></i> گزینه‌های لیست
                    </h4>
                    <button id="lookup-add-item-btn" onclick="app.addLookupRow()" class="btn-primary px-4 py-1.5 rounded-lg text-[11px] font-bold">
                        <i class="fa-solid fa-plus ml-1"></i> افزودن گزینه جدید
                    </button>
                </div>
            </div>

            <div class="overflow-x-auto border border-gray-800 rounded-xl">
                <table class="w-full text-right text-sm">
                    <thead class="bg-gray-800/80 text-gray-400">
                        <tr>
                            <th class="p-3 font-medium">عنوان نمایش</th>
                            <th class="p-3 font-medium">مقدار (Value)</th>
                            <th class="p-3 font-medium">کد (Code)</th>
                            <th class="p-3 font-medium">Meta JSON</th>
                            <th class="p-3 font-medium">والد</th>
                            <th class="p-3 font-medium w-20 text-center">ترتیب</th>
                            <th class="p-3 font-medium w-20 text-center">فعال</th>
                            <th class="p-3 font-medium text-center">عملیات</th>
                        </tr>
                    </thead>
                    <tbody id="lookup-items-table" class="divide-y divide-gray-800 text-gray-300 bg-gray-900/20"></tbody>
                </table>
            </div>
            <p class="text-[10px] text-gray-500 mt-3 italic">* تغییرات آیتم‌ها بصورت ردیفی اعمال می‌شود. برای هر ردیف دکمه ذخیره وجود دارد.</p>
        </div>
    </div>

    <!-- Hidden separate tab content (removed UI, but kept container for JS compatibility if needed) -->
    <div id="lookup-fields-tab" class="hidden"></div>
</div>
<?php endif; ?>
<!-- 4.5 EXPORTS VIEW (ADMIN) -->
<div id="view-exports" class="view-section h-full p-6 hidden flex flex-col overflow-y-auto pb-24">
    <div class="glass p-6">
        <div class="flex justify-between items-center mb-4">
            <h3 class="font-bold text-white">گزارشات (مدیر)</h3>
            <button onclick="app.loadExportCatalog(true)" class="text-xs text-gray-400 hover:text-white">
                <i class="fa-solid fa-rotate-right ml-1"></i> بروزرسانی
            </button>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-3">
            <div>
                <label class="block text-xs text-gray-400 mb-1">نوع خروجی</label>
                <select id="export-dataset" class="input bg-gray-800 w-full" onchange="app.onExportDatasetChange()">
                    <option value="">در حال بارگذاری...</option>
                </select>
            </div>
            <div>
                <label class="block text-xs text-gray-400 mb-1">فرمت</label>
                <select id="export-format" class="input bg-gray-800 w-full">
                    <option value="csv">CSV</option>
                    <option value="xlsx">Excel (XLSX)</option>
                </select>
                <p class="text-[11px] text-gray-500 mt-1">برای خروجی‌های بزرگ، CSV سریع‌تر و مطمئن‌تر است.</p>
            </div>
            <div class="flex items-end">
                <button onclick="app.submitExport()" class="btn-primary w-full py-2 rounded">
                    <i class="fa-solid fa-download ml-1"></i> دانلود خروجی
                </button>
            </div>
        </div>

        <div id="export-filters" class="mt-6 grid grid-cols-1 md:grid-cols-3 gap-3"></div>

        <div class="mt-6">
            <div class="flex items-center justify-between gap-3 mb-2">
                <h4 class="font-bold text-white text-sm">ستون‌ها</h4>
                <div class="flex gap-2 items-center">
                    <input id="export-columns-search" type="text" class="input bg-gray-800 text-xs w-56" placeholder="جستجوی ستون..." oninput="app.filterExportColumns()">
                    <button type="button" class="px-3 py-2 rounded bg-gray-700 hover:bg-gray-600 text-xs" onclick="app.selectAllExportColumns(true)">انتخاب همه</button>
                    <button type="button" class="px-3 py-2 rounded bg-gray-700 hover:bg-gray-600 text-xs" onclick="app.selectAllExportColumns(false)">حذف همه</button>
                </div>
            </div>
            <div id="export-columns" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-2"></div>
        </div>

        <form id="export-form" method="POST" action="?api=export_run" class="hidden">
            <input type="hidden" name="dataset" id="export-form-dataset" value="">
            <input type="hidden" name="format" id="export-form-format" value="">
            <input type="hidden" name="columns_json" id="export-form-columns" value="[]">
            <input type="hidden" name="filters_json" id="export-form-filters" value="{}">
        </form>
    </div>
</div>

<!-- 4.6 AUDIT LOGS VIEW (ADMIN) -->
<div id="view-audit-logs" class="view-section h-full p-6 hidden flex flex-col overflow-y-auto pb-24">
    <div class="glass p-6">
        <div class="flex justify-between items-center mb-4">
            <h3 class="font-bold text-white">لاگ فعالیت کاربران (سیستمی و رابط کاربری)</h3>
            <button onclick="app.loadAuditLogs(true)" class="text-xs text-gray-400 hover:text-white">
                <i class="fa-solid fa-rotate-right ml-1"></i> بروزرسانی
            </button>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-4 gap-3 mb-4">
            <div>
                <label class="block text-xs text-gray-400 mb-1">نوع عملیات</label>
                <select id="audit-filter-action" class="input bg-gray-800 w-full" onchange="app.loadAuditLogs(true)">
                    <option value="">همه</option>
                    <option value="login">ورود به سیستم</option>
                    <option value="logout">خروج</option>
                    <option value="delete">حذف</option>
                    <option value="owner_change">تغییر مسئول</option>
                    <option value="Click">کلیک‌ها (UI)</option>
                    <option value="HTTP POST">تغییرات داده (POST)</option>
                    <option value="HTTP GET">مشاهده صفحات</option>
                </select>
            </div>
            <div>
                <label class="block text-xs text-gray-400 mb-1">نوع رکورد</label>
                <select id="audit-filter-entity" class="input bg-gray-800 w-full" onchange="app.loadAuditLogs(true)">
                    <option value="">همه</option>
                    <option value="person">لید</option>
                    <option value="deal">معامله</option>
                    <option value="system">سیستم</option>
                    <option value="client_ui">رابط کاربری</option>
                </select>
            </div>
            <div>
                <label class="block text-xs text-gray-400 mb-1">جستجوی شخص (نام/موبایل)</label>
                <input id="audit-filter-person" type="text" class="input bg-gray-800 w-full" placeholder="نام یا شماره..." onkeypress="if(event.key==='Enter') app.loadAuditLogs(true)">
            </div>
            <div>
                <label class="block text-xs text-gray-400 mb-1">از تاریخ (شمسی)</label>
                <input id="audit-filter-from" type="text" class="input bg-gray-800 w-full" placeholder="1403/10/01" onkeypress="if(event.key==='Enter') app.loadAuditLogs(true)" data-jalali-picker="1">
            </div>
            <div>
                <label class="block text-xs text-gray-400 mb-1">تا تاریخ (شمسی)</label>
                <input id="audit-filter-to" type="text" class="input bg-gray-800 w-full" placeholder="1403/10/30" onkeypress="if(event.key==='Enter') app.loadAuditLogs(true)" data-jalali-picker="1">
            </div>
        </div>

        <div class="overflow-x-auto">
            <table class="w-full text-right text-sm min-w-[1000px]">
                <thead class="bg-gray-800 text-gray-400">
                    <tr>
                        <th class="p-3">زمان</th>
                        <th class="p-3">کاربر</th>
                        <th class="p-3">شخص مرتبط</th>
                        <th class="p-3">IP</th>
                        <th class="p-3">عملیات</th>
                        <th class="p-3">نوع</th>
                        <th class="p-3">جزئیات</th>
                    </tr>
                </thead>
                <tbody id="audit-logs-table" class="divide-y divide-gray-700 text-gray-300"></tbody>
            </table>
        </div>

        <div class="flex justify-between items-center mt-4 text-xs text-gray-400">
            <button class="px-3 py-2 rounded bg-gray-700 hover:bg-gray-600" onclick="app.auditLogsPrev()">قبلی</button>
            <span id="audit-logs-info">-</span>
            <button class="px-3 py-2 rounded bg-gray-700 hover:bg-gray-600" onclick="app.auditLogsNext()">بعدی</button>
        </div>
    </div>
</div>

<!-- 5. USERS VIEW (ADMIN) -->
<div id="view-users" class="view-section h-full p-6 hidden flex flex-col overflow-y-auto pb-24">
    <div class="glass p-6">
        <div class="flex justify-between mb-6">
            <h3 class="font-bold text-white">کاربران و کارشناسان</h3>
            <div class="flex gap-2">
                <button onclick="app.syncDidarUsers()" class="btn-primary px-4 py-2 rounded text-xs bg-purple-600 hover:bg-purple-700" title="همگام‌سازی کاربران با Didar برای درست کردن Owner IDs">
                    <i class="fa-solid fa-sync ml-1"></i> همگام‌سازی Didar
                </button>
                <button onclick="app.runMigration()" class="btn-primary px-4 py-2 rounded text-xs bg-blue-600 hover:bg-blue-700">
                    <i class="fa-solid fa-database ml-1"></i> اجرای Migration
                </button>
                <button onclick="app.openUserModal()" class="btn-primary px-4 py-2 rounded text-xs">افزودن کاربر</button>
            </div>
        </div>
        <div class="overflow-x-auto">
            <table class="w-full text-right text-sm min-w-[700px]">
                <thead class="bg-gray-800 text-gray-400">
                    <tr>
                        <th class="p-3">نام</th>
                        <th class="p-3">نام کاربری</th>
                        <th class="p-3">نقش</th>
                        <th class="p-3">Didar ID</th>
                        <th class="p-3">عملیات</th>
                    </tr>
                </thead>
                <tbody id="users-table" class="divide-y divide-gray-700 text-gray-300"></tbody>
            </table>
        </div>
    </div>
    <div id="crm-owner-settings" class="glass p-6 mt-6 space-y-3">
        <div class="flex items-center justify-between">
            <div>
                <h4 class="font-bold text-white text-sm">کارشناس CRM پیش‌فرض</h4>
                <p class="text-xs text-gray-400 mt-1">لیدهای ارجاع‌شده به این کارشناس منتقل می‌شوند</p>
            </div>
            <button type="button" onclick="app.saveCrmOwner()" class="btn-primary px-4 py-2 rounded text-xs">ذخیره</button>
        </div>
        <select id="crm-owner-select" class="input bg-gray-800">
            <option value="">در حال بارگذاری کاربران دیدار...</option>
        </select>
        <p class="text-xs text-gray-500" id="crm-owner-current"></p>
    </div>
</div>

<!-- 6. PERSONS VIEW -->
<div id="view-persons" class="view-section h-full p-6 hidden flex flex-col">
    <div class="glass flex-1 overflow-hidden flex flex-col">
        <div class="p-4 border-b border-gray-700 flex justify-between items-center">
            <h3 class="font-bold text-yellow-500">لیست اشخاص</h3>
            <input type="text" id="persons-search" placeholder="جستجو..." class="input w-full md:w-64 bg-gray-800">
        </div>
        <div class="overflow-y-auto p-4 pb-24">
            <div id="persons-list" class="space-y-2"></div>
        </div>
    </div>
</div>

<!-- 7. REMINDERS VIEW -->
<div id="view-reminders" class="view-section h-full p-6 hidden flex flex-col">
    <div class="glass flex-1 overflow-hidden flex flex-col">
        <div class="p-4 border-b border-gray-700 flex justify-between items-center">
            <h3 class="font-bold text-blue-500">لیست یادآوری‌های فعالیت</h3>
            <button class="btn-primary px-4 py-2 rounded text-sm flex items-center gap-2" onclick="app.loadReminders()">
                <i class="fa-solid fa-rotate-right"></i>
                بروزرسانی
            </button>
        </div>
        <div class="flex-1 overflow-y-auto p-4 pb-24">
            <div id="reminders-list-container" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-4">
                <div class="text-center text-gray-500 py-10 col-span-full">در حال بارگذاری...</div>
            </div>
        </div>
    </div>
</div>

