<!-- APP DASHBOARD -->
<div class="flex h-full relative">
    <!-- Mobile Sidebar Backdrop -->
    <div id="sidebar-backdrop" onclick="app.toggleSidebar()" class="fixed inset-0 bg-black/50 z-20 hidden md:hidden backdrop-blur-sm transition-opacity"></div>

    <!-- Sidebar -->
    <aside id="main-sidebar" class="w-64 bg-gray-900 border-l border-gray-800 flex flex-col z-30 shadow-xl fixed inset-y-0 right-0 transform translate-x-full transition-transform duration-300 md:translate-x-0 md:relative">
        <div class="p-6 border-b border-gray-800 flex justify-between items-center">
            <div class="flex items-center gap-3">
                <img src="/logo.png" alt="Hanifi Academy" class="w-10 h-10 object-contain">
                <h1 class="text-lg font-black text-yellow-500 tracking-wide">HANIFI<span class="text-white">ACADEMY</span></h1>
            </div>
            <!-- Close button for mobile -->
            <button onclick="app.toggleSidebar()" class="md:hidden text-gray-400 hover:text-white">
                <i class="fa-solid fa-times text-xl"></i>
            </button>
        </div>
        
        <div class="px-6 py-2 border-b border-gray-800/50">
            <div class="flex items-center gap-2">
                <div class="w-2 h-2 bg-green-500 rounded-full animate-pulse"></div>
                <span class="text-xs text-gray-400" id="user-display">...</span>
            </div>
        </div>
        
        <nav class="flex-1 p-4 overflow-y-auto">
            <div onclick="app.setView('dashboard'); app.closeSidebar()" id="menu-dashboard" class="sidebar-item active">
                <i class="fa-solid fa-chart-line"></i> داشبورد
            </div>
            <div onclick="app.setView('leads'); app.closeSidebar()" id="menu-leads" class="sidebar-item">
                <i class="fa-solid fa-filter"></i> لیدها
            </div>
            <div onclick="app.setView('blataklif-leads'); app.closeSidebar()" id="menu-blataklif-leads" class="sidebar-item">
                <i class="fa-solid fa-circle-exclamation"></i> لیدهای بلاتکلیف
            </div>
            <div onclick="app.setView('deals'); app.closeSidebar()" id="menu-deals" class="sidebar-item">
                <i class="fa-solid fa-sack-dollar"></i> معاملات
            </div>
            <div onclick="app.setView('legacy-deals'); app.closeSidebar()" id="menu-legacy-deals" class="sidebar-item">
                <i class="fa-solid fa-clock-rotate-left"></i> معاملات گذشته دیدار
            </div>
            <?php if(isAdminOrCrmSpecialist()): ?>
            <div onclick="app.setView('referrals'); app.closeSidebar()" id="menu-referrals" class="sidebar-item">
                <i class="fa-solid fa-share-nodes"></i> ارجاعات
            </div>
            <?php endif; ?>
            <div onclick="app.setView('persons'); app.closeSidebar()" id="menu-persons" class="sidebar-item">
                <i class="fa-solid fa-users"></i> اشخاص
            </div>
            <div onclick="app.setView('reminders'); app.closeSidebar()" id="menu-reminders" class="sidebar-item">
                <i class="fa-solid fa-clock-rotate-left"></i> یادآوری‌ها
            </div>
            <div onclick="app.setView('settings'); app.closeSidebar()" id="menu-settings" class="sidebar-item">
                <i class="fa-solid fa-gear"></i> تنظیمات
            </div>
            
	            <!-- Admin Menu -->
	            <div id="admin-section" class="<?php echo isAdmin() ? '' : 'hidden'; ?> mt-6 pt-4 border-t border-gray-800">
	                <p class="text-[10px] text-gray-500 px-2 mb-2 font-bold">مدیریت</p>
<div onclick="app.setView('lookups'); app.closeSidebar()" id="menu-lookups" class="sidebar-item">
                    <i class="fa-solid fa-list-check"></i> Lookup Manager
                </div>
	                <div onclick="app.setView('exports'); app.closeSidebar()" id="menu-exports" class="sidebar-item">
	                    <i class="fa-solid fa-file-export"></i> گزارشات
	                </div>
	                <div onclick="app.setView('audit-logs'); app.closeSidebar()" id="menu-audit-logs" class="sidebar-item">
	                    <i class="fa-solid fa-clipboard-list"></i> لاگ فعالیت کاربران
	                </div>
	                <div onclick="app.setView('users'); app.closeSidebar()" id="menu-users" class="sidebar-item">
	                    <i class="fa-solid fa-users-gear"></i> کاربران سیستم
	                </div>
	            </div>

	            <!-- KPI Dashboard (Admin Only) -->
	            <?php if(isAdmin()): ?>
	            <div class="mt-6 pt-4 border-t border-gray-800">
	                <p class="text-[10px] text-gray-500 px-2 mb-2 font-bold">داشبورد مالی</p>
<div onclick="app.showKPIDashboard(); app.closeSidebar()" id="menu-kpi" class="sidebar-item">
	                    <i class="fa-solid fa-chart-pie"></i> داشبورد KPI
	                </div>
	            </div>
	            <?php endif; ?>
        </nav>

        <div class="p-4 border-t border-gray-800">
            <?php if(($_SESSION['role'] ?? '') === 'admin'): ?>
            <button onclick="app.sync()" class="w-full bg-blue-600 hover:bg-blue-500 text-white py-2 rounded-lg font-bold text-sm mb-2 shadow-lg transition">
                <i class="fa-solid fa-sync ml-1"></i> همگام‌سازی
            </button>
            <?php endif; ?>
            <a href="?logout" class="block text-center text-red-500/60 hover:text-red-400 text-xs py-2">خروج از حساب</a>
        </div>
    </aside>

    <!-- Content -->
    <main class="flex-1 flex flex-col relative overflow-hidden w-full">
        <header class="h-16 border-b border-gray-800 flex items-center justify-between px-4 md:px-6 bg-gray-900/50 backdrop-blur sticky top-0 z-10">
            <div class="flex items-center gap-3">
                <button onclick="app.toggleSidebar()" class="md:hidden text-gray-400 hover:text-white p-2">
                    <i class="fa-solid fa-bars text-xl"></i>
                </button>
                <h2 class="text-lg font-bold text-white" id="page-title">داشبورد</h2>
            </div>
            <div class="flex items-center gap-2 md:gap-4">
                <!-- Notification Settings -->
                <div class="relative">
                    <button onclick="app.showNotificationSettings()" class="text-purple-400 hover:text-purple-300 transition p-2 rounded-full hover:bg-gray-800 focus:outline-none focus:ring-2 focus:ring-gray-700" title="تنظیمات نوتیفیکیشن">
                        <i class="fa-solid fa-cog text-lg"></i>
                    </button>
                </div>

                <!-- Sound Toggle -->
                <button onclick="app.toggleNotificationSound()" class="text-green-400 hover:text-green-300 transition p-2 rounded-full hover:bg-gray-800 focus:outline-none focus:ring-2 focus:ring-gray-700" title="تغییر وضعیت صدا" id="sound-toggle-btn">
                    <i class="fa-solid fa-volume-up text-xl"></i>
                </button>

                <!-- Theme Toggle -->
                <button onclick="app.toggleTheme()" class="text-gray-400 hover:text-white transition p-2 rounded-full hover:bg-gray-800 focus:outline-none focus:ring-2 focus:ring-gray-700" title="تغییر تم">
                    <i class="fa-solid fa-sun text-xl" id="theme-icon"></i>
                </button>
                <!-- Notifications -->
                <div class="relative" id="notifications-container">
                    <button onclick="app.toggleNotifications()" class="relative text-gray-400 hover:text-white transition p-2 rounded-full hover:bg-gray-800 focus:outline-none focus:ring-2 focus:ring-gray-700">
                        <i class="fa-solid fa-bell text-xl"></i>
                        <span id="notification-badge" class="absolute top-1 right-1 bg-red-500 text-white text-[10px] rounded-full w-4 h-4 flex items-center justify-center hidden">0</span>
                    </button>
                    <!-- Notifications Dropdown -->
                    <div id="notifications-dropdown" class="hidden absolute left-0 top-14 w-80 bg-gray-800 rounded-lg shadow-2xl border border-gray-700 max-h-96 overflow-y-auto z-50">
                        <div class="p-4 border-b border-gray-700 flex items-center justify-between">
                            <h3 class="font-bold text-white">اعلان‌ها</h3>
                            <button onclick="app.markAllNotificationsRead()" class="text-xs text-blue-400 hover:text-blue-300">همه را خوانده شده</button>
                        </div>
                        <div id="notifications-list" class="p-2">
                            <div class="text-center text-gray-500 text-sm py-8">در حال بارگذاری...</div>
                        </div>
                    </div>
                </div>
                <?php if(($_SESSION['role'] ?? '') === 'admin'): ?>
                <button onclick="app.testNotification()" class="text-gray-400 hover:text-yellow-400 transition p-2 rounded-full hover:bg-gray-800 focus:outline-none focus:ring-2 focus:ring-gray-700" title="تست اعلان">
                    <i class="fa-solid fa-vial text-lg"></i>
                </button>
                <button onclick="app.testPolling()" class="text-gray-400 hover:text-blue-400 transition p-2 rounded-full hover:bg-gray-800 focus:outline-none focus:ring-2 focus:ring-gray-700" title="تست یادآوری‌ها">
                    <i class="fa-solid fa-clock text-lg"></i>
                </button>
                <button onclick="app.testPopupDirect()" class="text-gray-400 hover:text-green-400 transition p-2 rounded-full hover:bg-gray-800 focus:outline-none focus:ring-2 focus:ring-gray-700" title="تست پاپ‌آپ مستقیم">
                    <i class="fa-solid fa-bell text-lg"></i>
                </button>
                <button onclick="app.testBrowserNotification()" class="text-gray-400 hover:text-blue-400 transition p-2 rounded-full hover:bg-gray-800 focus:outline-none focus:ring-2 focus:ring-gray-700" title="تست نوتیفیکیشن مرورگر">
                    <i class="fa-solid fa-desktop text-lg"></i>
                </button>
                <?php endif; ?>
                <button onclick="app.refresh()" class="text-gray-400 hover:text-white transition p-2 rounded-full hover:bg-gray-800 focus:outline-none focus:ring-2 focus:ring-gray-700"><i class="fa-solid fa-rotate-right text-lg"></i></button>
            </div>
        </header>

        <?php include __DIR__ . '/dashboard-views.php'; ?>
        
        <?php include __DIR__ . '/dashboard-modals.php'; ?>
    </main>
</div>



