<!-- LOGIN -->
<div class="flex h-full items-center justify-center">
    <div class="glass p-8 w-full max-w-sm shadow-2xl">
        <div class="text-center mb-8">
            <div class="flex items-center justify-center mx-auto mb-3">
                <img src="/logo.png" alt="Hanifi Academy" class="w-24 h-24 object-contain drop-shadow-2xl">
            </div>
            <h1 class="text-xl font-bold text-white">آکادمی حنفی‌کار</h1>
        </div>
        <form onsubmit="app.login(event)" class="space-y-4">
            <select name="username" id="login-user-select" required class="input bg-gray-800">
                <option value="">-- انتخاب کاربر --</option>
            </select>
            <input type="password" name="password" id="login-password" placeholder="رمز عبور" required class="input bg-gray-800" autocomplete="current-password">
            <button type="submit" class="btn-primary w-full py-2.5 rounded-lg">ورود به پنل</button>
        </form>
    </div>
</div>
<script>
    // Load users for login
    fetch('?api=get_login_users', {method: 'POST'})
        .then(r => r.json())
        .then(data => {
            console.log('Login users response:', data);
            if(data.status === 'success' && data.users && data.users.length > 0) {
                const select = document.getElementById('login-user-select');
                if (select) {
                    data.users.forEach(u => {
                        const opt = document.createElement('option');
                        // Use display_name as value since it's guaranteed to exist
                        const value = u.display_name || (u.first_name + ' ' + u.last_name);
                        opt.value = value;
                        const roleText = u.role === 'admin' ? ' (مدیر)' : (u.role === 'crm_specialist' ? ' (کارشناس CRM)' : '');
                        opt.textContent = value + roleText;
                        opt.dataset.username = u.username || value;
                        select.appendChild(opt);
                    });
                }
            } else {
                console.error('Failed to load users:', data);
                const select = document.getElementById('login-user-select');
                if (select) {
                    const opt = document.createElement('option');
                    opt.value = '';
                    opt.textContent = data.message || 'خطا در بارگذاری لیست کاربران';
                    select.appendChild(opt);
                }
            }
        })
        .catch(error => {
            console.error('Error loading users:', error);
            const select = document.getElementById('login-user-select');
            if (select) {
                const opt = document.createElement('option');
                opt.value = '';
                opt.textContent = 'خطا در ارتباط با سرور';
                select.appendChild(opt);
            }
        });
</script>

