<!-- SETUP -->
<div id="setup-container" class="flex h-full items-center justify-center p-4">
    <!-- Step 1: API Key -->
    <div id="setup-step1" class="glass p-8 w-full max-w-md border-t-4 border-yellow-500 shadow-2xl">
        <div class="text-center mb-6">
            <h1 class="text-3xl font-black text-yellow-500">HANIFI<span class="text-white">ACADEMY</span></h1>
            <p class="text-xs text-gray-400 mt-1">نصب سیستم CRM</p>
        </div>
        <form onsubmit="app.setupInit(event)" class="space-y-4">
            <input type="text" name="api_key" id="setup-api-key" placeholder="API Key دیدار" required class="input text-center dir-ltr">
            <button type="submit" class="btn-primary w-full py-3 rounded-lg">ادامه</button>
        </form>
    </div>
    
    <!-- Step 2: Select Admin -->
    <div id="setup-step2" class="glass p-8 w-full max-w-md border-t-4 border-yellow-500 shadow-2xl hidden">
        <div class="text-center mb-6">
            <h2 class="text-xl font-bold text-white">انتخاب کاربر ادمین</h2>
            <p class="text-xs text-gray-400 mt-1">کاربر ادمین را از لیست انتخاب کنید</p>
        </div>
        <div id="setup-users-list" class="space-y-2 max-h-64 overflow-y-auto mb-4"></div>
        <button onclick="app.setupComplete()" class="btn-primary w-full py-3 rounded-lg">تکمیل نصب</button>
    </div>
    
    <!-- Step 3: Progress -->
    <div id="setup-step3" class="glass p-8 w-full max-w-md border-t-4 border-yellow-500 shadow-2xl hidden">
        <div class="text-center mb-6">
            <h2 class="text-xl font-bold text-white">بارگذاری داده‌ها</h2>
            <p class="text-xs text-gray-400 mt-1" id="setup-progress-text">در حال بارگذاری...</p>
        </div>
        <div class="w-full bg-gray-700 rounded-full h-4 mb-4">
            <div id="setup-progress-bar" class="bg-yellow-500 h-4 rounded-full transition-all duration-300" style="width: 0%"></div>
        </div>
        <div id="setup-progress-detail" class="text-sm text-gray-400 mb-4"></div>
        <button id="setup-resume-btn" onclick="app.resumeSync()" class="btn-primary w-full py-2 rounded-lg hidden">
            <i class="fa-solid fa-play ml-1"></i> ادامه همگام‌سازی
        </button>
    </div>
</div>

